/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.rpkirepositories;

import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import net.ripe.rpki.validator3.api.rpkirepositories.RpkiRepositoriesController;
import net.ripe.rpki.validator3.api.util.Dates;
import net.ripe.rpki.validator3.domain.constraints.ValidLocationURI;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class RpkiRepositoryResource {
    @ApiModelProperty(allowableValues="rpki-repository", required=true, position=1)
    final String type;
    @ApiModelProperty(required=true, allowableValues="range[1,infinity]", example="1", position=2)
    final long id;
    @NotNull
    @ValidLocationURI
    final String locationURI;
    @NotNull
    final RpkiRepository.Status status;
    final String lastDownloadedAt;
    final String rrdpSessionId;
    final BigInteger rrdpSerial;
    final Links links;

    public static RpkiRepositoryResource of(RpkiRepository rpkiRepository) {
        return RpkiRepositoryResource.of((String)RpkiRepositoryResource.repositoryType((RpkiRepository)rpkiRepository), (long)rpkiRepository.key().asLong(), (String)rpkiRepository.getLocationUri(), (RpkiRepository.Status)rpkiRepository.getStatus(), (String)Dates.formatUTC((TemporalAccessor)rpkiRepository.getLastDownloadedAt()), (String)rpkiRepository.getRrdpSessionId(), (BigInteger)rpkiRepository.getRrdpSerial(), (Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((RpkiRepositoriesController)ControllerLinkBuilder.methodOn(RpkiRepositoriesController.class, (Object[])new Object[0])).get(rpkiRepository.key().asLong())).withSelfRel()}));
    }

    private static String repositoryType(RpkiRepository rpkiRepository) {
        return rpkiRepository.getType() == RpkiRepository.Type.RRDP ? "RRDP" : "RSYNC";
    }

    @ConstructorProperties(value={"type", "id", "locationURI", "status", "lastDownloadedAt", "rrdpSessionId", "rrdpSerial", "links"})
    private RpkiRepositoryResource(String type, long id, String locationURI, RpkiRepository.Status status, String lastDownloadedAt, String rrdpSessionId, BigInteger rrdpSerial, Links links) {
        this.type = type;
        this.id = id;
        this.locationURI = locationURI;
        this.status = status;
        this.lastDownloadedAt = lastDownloadedAt;
        this.rrdpSessionId = rrdpSessionId;
        this.rrdpSerial = rrdpSerial;
        this.links = links;
    }

    public static RpkiRepositoryResource of(String type, long id, String locationURI, RpkiRepository.Status status, String lastDownloadedAt, String rrdpSessionId, BigInteger rrdpSerial, Links links) {
        return new RpkiRepositoryResource(type, id, locationURI, status, lastDownloadedAt, rrdpSessionId, rrdpSerial, links);
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public RpkiRepository.Status getStatus() {
        return this.status;
    }

    public String getLastDownloadedAt() {
        return this.lastDownloadedAt;
    }

    public String getRrdpSessionId() {
        return this.rrdpSessionId;
    }

    public BigInteger getRrdpSerial() {
        return this.rrdpSerial;
    }

    public Links getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpkiRepositoryResource)) {
            return false;
        }
        RpkiRepositoryResource other = (RpkiRepositoryResource)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$locationURI = this.getLocationURI();
        String other$locationURI = other.getLocationURI();
        if (this$locationURI == null ? other$locationURI != null : !this$locationURI.equals(other$locationURI)) {
            return false;
        }
        RpkiRepository.Status this$status = this.getStatus();
        RpkiRepository.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$lastDownloadedAt = this.getLastDownloadedAt();
        String other$lastDownloadedAt = other.getLastDownloadedAt();
        if (this$lastDownloadedAt == null ? other$lastDownloadedAt != null : !this$lastDownloadedAt.equals(other$lastDownloadedAt)) {
            return false;
        }
        String this$rrdpSessionId = this.getRrdpSessionId();
        String other$rrdpSessionId = other.getRrdpSessionId();
        if (this$rrdpSessionId == null ? other$rrdpSessionId != null : !this$rrdpSessionId.equals(other$rrdpSessionId)) {
            return false;
        }
        BigInteger this$rrdpSerial = this.getRrdpSerial();
        BigInteger other$rrdpSerial = other.getRrdpSerial();
        if (this$rrdpSerial == null ? other$rrdpSerial != null : !((Object)this$rrdpSerial).equals(other$rrdpSerial)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpkiRepositoryResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $locationURI = this.getLocationURI();
        result = result * 59 + ($locationURI == null ? 43 : $locationURI.hashCode());
        RpkiRepository.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $lastDownloadedAt = this.getLastDownloadedAt();
        result = result * 59 + ($lastDownloadedAt == null ? 43 : $lastDownloadedAt.hashCode());
        String $rrdpSessionId = this.getRrdpSessionId();
        result = result * 59 + ($rrdpSessionId == null ? 43 : $rrdpSessionId.hashCode());
        BigInteger $rrdpSerial = this.getRrdpSerial();
        result = result * 59 + ($rrdpSerial == null ? 43 : ((Object)$rrdpSerial).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    public String toString() {
        return "RpkiRepositoryResource(type=" + this.getType() + ", id=" + this.getId() + ", locationURI=" + this.getLocationURI() + ", status=" + this.getStatus() + ", lastDownloadedAt=" + this.getLastDownloadedAt() + ", rrdpSessionId=" + this.getRrdpSessionId() + ", rrdpSerial=" + this.getRrdpSerial() + ", links=" + this.getLinks() + ")";
    }
}

