/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import java.util.HashMap;
import java.util.Map;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TrustAnchorState {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorState.class);
    private final Map<String, State> states = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allTAsValidatedAfterRepositoryLoading() {
        Map map = this.states;
        synchronized (map) {
            return this.states.values().stream().allMatch(s -> s.equals((Object)State.VALIDATED));
        }
    }

    public void setUnknown(TrustAnchor ta) {
        this.setState(ta, State.UNKNOWN);
    }

    public void setValidatedAfterLastRepositoryUpdate(TrustAnchor ta) {
        this.setState(ta, State.VALIDATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(TrustAnchor ta, State state) {
        Map map = this.states;
        synchronized (map) {
            State previousState = this.states.put(ta.getName(), state);
            if (state != previousState) {
                log.debug("Setting TA {} to {}", (Object)ta.getName(), (Object)state);
            }
        }
    }
}

