/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import net.ripe.rpki.validator3.storage.Bytes;
import net.ripe.rpki.validator3.storage.MultIxMap;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import net.ripe.rpki.validator3.storage.xodus.XodusIxBase;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class XodusMultIxMap<T extends Serializable>
extends XodusIxBase<T>
implements MultIxMap<T> {
    public XodusMultIxMap(Xodus xodus, String name, Coder<T> coder) {
        super(xodus, name, coder);
    }

    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITH_DUPLICATES;
    }

    public List<T> get(Tx.Read tx, Key primaryKey) {
        this.verifyKey(primaryKey);
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        try (Cursor cursor = this.getMainDb().openCursor(XodusMultIxMap.castTxn((Tx.Read)tx));){
            ByteIterable startKey = cursor.getSearchKey(primaryKey.toByteIterable());
            if (startKey != null) {
                result.add(this.getValue(primaryKey, Bytes.toBytes((ByteIterable)cursor.getValue())));
                while (cursor.getNextDup()) {
                    result.add(this.getValue(primaryKey, Bytes.toBytes((ByteIterable)cursor.getValue())));
                }
            }
        }
        return result;
    }

    public int count(Tx.Read tx, Key primaryKey) {
        this.verifyKey(primaryKey);
        int s = 0;
        try (Cursor cursor = this.getMainDb().openCursor(XodusMultIxMap.castTxn((Tx.Read)tx));){
            ByteIterable startKey = cursor.getSearchKey(primaryKey.toByteIterable());
            if (startKey != null) {
                ++s;
                while (cursor.getNextDup()) {
                    ++s;
                }
            }
        }
        return s;
    }

    public void put(Tx.Write tx, Key primaryKey, T value) {
        this.checkKeyAndValue(primaryKey, value);
        this.getMainDb().put(XodusMultIxMap.castTxn((Tx.Read)tx), primaryKey.toByteIterable(), this.valueWithChecksum(value));
    }

    public void delete(Tx.Write tx, Key primaryKey) {
        this.getMainDb().delete(XodusMultIxMap.castTxn((Tx.Read)tx), primaryKey.toByteIterable());
    }

    public void delete(Tx.Write tx, Key primaryKey, T value) {
        this.verifyKey(primaryKey);
        try (Cursor c = this.getMainDb().openCursor(XodusMultIxMap.castTxn((Tx.Read)tx));){
            if (c.getSearchBoth(primaryKey.toByteIterable(), this.valueWithChecksum(value))) {
                c.deleteCurrent();
            }
        }
    }

    public void deleteBatch(Tx.Write tx, List<Pair<Key, T>> toDelete) {
        try (Cursor c = this.getMainDb().openCursor(XodusMultIxMap.castTxn((Tx.Read)tx));){
            toDelete.forEach(p -> {
                if (c.getSearchBoth(((Key)p.getKey()).toByteIterable(), this.valueWithChecksum((Serializable)p.getValue()))) {
                    c.deleteCurrent();
                }
            });
        }
    }

    public T toValue(byte[] bb) {
        return (T)this.getValue(null, bb);
    }

    public boolean exists(Tx.Read tx, Key pk, T value) {
        try (Cursor c = this.getMainDb().openCursor(XodusMultIxMap.castTxn((Tx.Read)tx));){
            boolean bl = c.getSearchBoth(pk.toByteIterable(), this.valueWithChecksum(value));
            return bl;
        }
    }
}

