/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.validationruns;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;

/*
 * Exception performing whole class analysis ignored.
 */
@ApiModel(value="ValidationCheck")
public class ValidationCheckResource {
    @ApiModelProperty(required=true, position=1, example="rsync://rpki.cnnic.cn/rpki/A9162E3D0000/BBYptqnqt8sTJOo5ePA3lviJtUA.crl")
    final String location;
    @ApiModelProperty(required=true, position=2, example="WARNING")
    final ValidationCheck.Status status;
    @ApiModelProperty(required=true, position=4, example="crl.next.update.before.now")
    final String key;
    @ApiModelProperty(required=true, position=3, example="[\"2020-01-09T23:15:45.000Z\"]")
    final List<String> parameters;
    @ApiModelProperty(required=false, position=5, example="CRL next update was expected on or before 2020-01-09T23:15:45.000Z")
    final String formattedMessage;
    @ApiModelProperty(required=false, position=6, example="1585662733733")
    final long createdAt;

    public static ValidationCheckResource of(ValidationCheck check, String formattedMessage) {
        return ValidationCheckResource.of((String)check.getLocation(), (ValidationCheck.Status)check.getStatus(), (String)check.getKey(), (List)check.getParameters(), (String)formattedMessage, (long)check.getCreatedAt().toEpochMilli());
    }

    @ConstructorProperties(value={"location", "status", "key", "parameters", "formattedMessage", "createdAt"})
    private ValidationCheckResource(String location, ValidationCheck.Status status, String key, List<String> parameters, String formattedMessage, long createdAt) {
        this.location = location;
        this.status = status;
        this.key = key;
        this.parameters = parameters;
        this.formattedMessage = formattedMessage;
        this.createdAt = createdAt;
    }

    public static ValidationCheckResource of(String location, ValidationCheck.Status status, String key, List<String> parameters, String formattedMessage, long createdAt) {
        return new ValidationCheckResource(location, status, key, parameters, formattedMessage, createdAt);
    }

    public String getLocation() {
        return this.location;
    }

    public ValidationCheck.Status getStatus() {
        return this.status;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationCheckResource)) {
            return false;
        }
        ValidationCheckResource other = (ValidationCheckResource)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        ValidationCheck.Status this$status = this.getStatus();
        ValidationCheck.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List this$parameters = this.getParameters();
        List other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$formattedMessage = this.getFormattedMessage();
        String other$formattedMessage = other.getFormattedMessage();
        if (this$formattedMessage == null ? other$formattedMessage != null : !this$formattedMessage.equals(other$formattedMessage)) {
            return false;
        }
        return this.getCreatedAt() == other.getCreatedAt();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationCheckResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        ValidationCheck.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $formattedMessage = this.getFormattedMessage();
        result = result * 59 + ($formattedMessage == null ? 43 : $formattedMessage.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        return result;
    }

    public String toString() {
        return "ValidationCheckResource(location=" + this.getLocation() + ", status=" + this.getStatus() + ", key=" + this.getKey() + ", parameters=" + this.getParameters() + ", formattedMessage=" + this.getFormattedMessage() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

