/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.stores.GenericStore;

public abstract class GenericStoreImpl<T extends Serializable>
implements GenericStore<T> {
    public Ref<T> makeRef(Tx.Read tx, Key key) {
        return Ref.of((Tx.Read)tx, (IxMap)this.ixMap(), (Key)key);
    }

    public List<T> values(Tx.Read tx) {
        return this.ixMap().values(tx);
    }

    public long size(Tx.Read tx) {
        return this.ixMap().size(tx);
    }

    public void forEach(Tx.Read tx, BiConsumer<Key, byte[]> bb) {
        this.ixMap().forEach(tx, bb);
    }

    public void clear(Tx.Write tx) {
        this.ixMap().clear(tx);
    }

    public void onDelete(BiConsumer<Tx.Write, Key> bf) {
        this.ixMap().onDelete(bf);
    }

    public boolean exists(Tx.Read tx, Key key) {
        return this.ixMap().exists(tx, key);
    }

    public Set<Key> keys(Tx.Read tx) {
        return this.ixMap().keys(tx);
    }

    protected abstract IxMap<T> ixMap();
}

