/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.trustanchors;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.ripe.rpki.validator3.api.ApiCommand;
import net.ripe.rpki.validator3.api.ApiError;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.trustanchors.AddTrustAnchor;
import net.ripe.rpki.validator3.api.trustanchors.TaStatus;
import net.ripe.rpki.validator3.api.trustanchors.TrustAnchorResource;
import net.ripe.rpki.validator3.api.trustanchors.TrustAnchorService;
import net.ripe.rpki.validator3.api.validationruns.ValidationCheckResource;
import net.ripe.rpki.validator3.api.validationruns.ValidationRunController;
import net.ripe.rpki.validator3.api.validationruns.ValidationRunResource;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.TrustAnchorExtractorException;
import net.ripe.rpki.validator3.util.TrustAnchorLocator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@PublicApiCall
@RestController
@Api(tags={"Trust Anchors"})
@RequestMapping(path={"/api/trust-anchors"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class TrustAnchorController {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorController.class);
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private TrustAnchorService trustAnchorService;
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Storage storage;

    @ApiOperation(value="List the configured Trust Anchors")
    @GetMapping
    public ResponseEntity<ApiResponse<List<TrustAnchorResource>>> list(Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> ResponseEntity.ok((Object)ApiResponse.data((Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((TrustAnchorController)ControllerLinkBuilder.methodOn(TrustAnchorController.class, (Object[])new Object[0])).list(locale)).withSelfRel()}), this.trustAnchors.findAll(tx).stream().map(ta -> TrustAnchorResource.of((TrustAnchor)ta, (Locale)locale)).collect(Collectors.toList()))));
    }

    @ApiOperation(value="Add a Trust Anchor using a JSON payload")
    @PostMapping(consumes={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
    public ResponseEntity<ApiResponse<TrustAnchorResource>> add(@RequestBody @Valid ApiCommand<AddTrustAnchor> command, Locale locale) {
        long id = this.trustAnchorService.execute((AddTrustAnchor)command.getData());
        return (ResponseEntity)this.storage.readTx(tx -> {
            TrustAnchor trustAnchor = (TrustAnchor)this.trustAnchors.get(tx, Key.of((long)id)).get();
            Link selfRel = ControllerLinkBuilder.linkTo((Object)((TrustAnchorController)ControllerLinkBuilder.methodOn(TrustAnchorController.class, (Object[])new Object[0])).get(id, locale)).withSelfRel();
            return ResponseEntity.created((URI)URI.create(selfRel.getHref())).body((Object)this.trustAnchorResource(tx, trustAnchor, locale));
        });
    }

    @ApiOperation(value="Add a Trust Anchor from a file")
    @PostMapping(path={"/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<ApiResponse<TrustAnchorResource>> add(@RequestParam(value="file") MultipartFile trustAnchorLocator, Locale locale) {
        try {
            TrustAnchorLocator locator = TrustAnchorLocator.fromMultipartFile((MultipartFile)trustAnchorLocator);
            AddTrustAnchor command = AddTrustAnchor.builder().type("trust-anchor").name(locator.getCaName()).locations(locator.getCertificateLocations().stream().map(URI::toASCIIString).collect(Collectors.toList())).subjectPublicKeyInfo(locator.getPublicKeyInfo()).rsyncPrefetchUri((String)locator.getPrefetchUris().stream().filter(uri -> "rsync".equalsIgnoreCase(uri.getScheme())).map(URI::toASCIIString).findFirst().orElse(null)).build();
            long id = this.trustAnchorService.execute(command);
            return (ResponseEntity)this.storage.readTx(tx -> {
                Optional trustAnchor = this.trustAnchors.get(tx, Key.of((long)id));
                Link selfRel = ControllerLinkBuilder.linkTo((Object)((TrustAnchorController)ControllerLinkBuilder.methodOn(TrustAnchorController.class, (Object[])new Object[0])).get(id, locale)).withSelfRel();
                return ResponseEntity.created((URI)URI.create(selfRel.getHref())).body((Object)this.trustAnchorResource(tx, (TrustAnchor)trustAnchor.get(), locale));
            });
        }
        catch (TrustAnchorExtractorException ex) {
            return ResponseEntity.badRequest().body((Object)ApiResponse.error((ApiError[])new ApiError[]{ApiError.of((HttpStatus)HttpStatus.BAD_REQUEST, (String)("Invalid trust anchor locator: " + ex.getMessage()))}));
        }
    }

    @ApiOperation(value="Get a trust anchor by (numeric) identifier")
    @GetMapping(path={"/{id}"})
    public ResponseEntity<ApiResponse<TrustAnchorResource>> get(@PathVariable long id, Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)id)).map(ta -> ResponseEntity.ok((Object)this.trustAnchorResource(tx, ta, locale))).orElse(ResponseEntity.notFound().build()));
    }

    @GetMapping(path={"/{id}/validation-run"})
    public ResponseEntity<ApiResponse<ValidationRunResource>> validationResults(@PathVariable long id, HttpServletResponse response, Locale locale) throws IOException {
        Optional validationRun = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)id)).flatMap(trustAnchor -> this.validationRuns.findLatestCompletedForTrustAnchor(tx, trustAnchor)));
        if (validationRun.isPresent()) {
            response.sendRedirect(ControllerLinkBuilder.linkTo((Object)((ValidationRunController)ControllerLinkBuilder.methodOn(ValidationRunController.class, (Object[])new Object[0])).get(((TrustAnchorValidationRun)validationRun.get()).key().asLong(), locale)).toString());
            return null;
        }
        return ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Get validation issues")
    @GetMapping(path={"/{id}/validation-checks"})
    public ResponseEntity<ApiResponse<Stream<ValidationCheckResource>>> validationChecks(@PathVariable long id, @RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", required=false) String searchString, @ApiParam(allowableValues="prefix, asn, ta, key, location, status, validity, type, lastchecked, comment, maximumlength") @RequestParam(name="sortBy", defaultValue="location") String sortBy, @ApiParam(allowableValues="asc, desc") @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection, Locale locale) {
        SearchTerm searchTerm = StringUtils.isNotBlank((String)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        return (ResponseEntity)this.storage.readTx(tx -> {
            int totalCount = this.validationRuns.countValidationChecksForValidationRun(tx, id, searchTerm);
            Stream<ValidationCheckResource> checks = this.validationRuns.findValidationChecksForValidationRun(tx, id, paging, searchTerm, sorting).map(check -> ValidationCheckResource.of((ValidationCheck)check, (String)this.messageSource.getMessage((MessageSourceResolvable)check, locale)));
            Links links = Paging.links((long)startFrom, (long)pageSize, (long)totalCount, (sf, ps) -> ((TrustAnchorController)ControllerLinkBuilder.methodOn(TrustAnchorController.class, (Object[])new Object[0])).validationChecks(id, sf.longValue(), ps.longValue(), searchString, sortBy, sortDirection, locale));
            return ResponseEntity.ok((Object)ApiResponse.builder().links(links).data(checks).metadata(Metadata.of((long)totalCount)).build());
        });
    }

    @ApiOperation(value="Get the statuses of all configured trust anchors")
    @GetMapping(path={"/statuses"})
    public ApiResponse<List<TaStatus>> statuses() {
        return (ApiResponse)this.storage.readTx(tx -> ApiResponse.builder().data((Object)this.trustAnchors.getStatuses(tx)).build());
    }

    @ApiOperation(value="Delete a trust anchor by id")
    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable long id) {
        this.trustAnchorService.remove(id);
        return ResponseEntity.noContent().build();
    }

    private ApiResponse<TrustAnchorResource> trustAnchorResource(Tx.Read tx, TrustAnchor trustAnchor, Locale locale) {
        Optional validationRun = this.validationRuns.findLatestCompletedForTrustAnchor(tx, trustAnchor);
        ArrayList includes = new ArrayList(1);
        validationRun.ifPresent(run -> includes.add(ValidationRunResource.of((ValidationRun)run, vr -> this.validationRuns.getObjectCount(tx, vr), (MessageSource)this.messageSource, (Locale)locale)));
        return ApiResponse.builder().data((Object)TrustAnchorResource.of((TrustAnchor)trustAnchor, (Locale)locale)).includes(includes).build();
    }
}

