/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roas;

import au.com.bytecode.opencsv.CSVWriter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterService;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionsService;
import net.ripe.rpki.validator3.api.roas.ExportsController;
import net.ripe.rpki.validator3.domain.IgnoreFiltersPredicate;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"VRP export"})
@PublicApiCall
@RestController
public class ExportsController {
    private static final Logger log = LoggerFactory.getLogger(ExportsController.class);
    public static final String JSON = "text/json; charset=UTF-8";
    public static final String CSV = "text/csv; charset=UTF-8";
    private final ValidatedRpkiObjects validatedRpkiObjects;
    private final IgnoreFilterService ignoreFilters;
    private final RoaPrefixAssertionsService roaPrefixAssertions;
    private final Settings settings;
    private final Storage storage;

    @Autowired
    public ExportsController(ValidatedRpkiObjects validatedRpkiObjects, IgnoreFilterService ignoreFilters, RoaPrefixAssertionsService roaPrefixAssertions, Settings settings, Storage storage) {
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.ignoreFilters = ignoreFilters;
        this.roaPrefixAssertions = roaPrefixAssertions;
        this.settings = settings;
        this.storage = storage;
    }

    @ApiOperation(value="export VRPs (json)")
    @GetMapping(path={"/api/export.json"})
    public JsonExport exportJson(HttpServletResponse response) {
        response.setContentType(JSON);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return null;
        }
        return new JsonExport(this.vrpStream());
    }

    @ApiOperation(value="export VRPs (CSV)")
    @GetMapping(path={"/api/export.csv"})
    public void exportCsv(HttpServletResponse response) throws IOException {
        response.setContentType(CSV);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return;
        }
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            writer.writeNext(new String[]{"ASN", "IP Prefix", "Max Length", "Trust Anchor"});
            this.vrpStream().forEach(prefix -> writer.writeNext(new String[]{prefix.getAsn(), prefix.getPrefix(), String.valueOf(prefix.getMaxLength()), prefix.getTa()}));
        }
    }

    @ApiOperation(value="export VRPs (JSON) extended with validity and serial number")
    @GetMapping(path={"/api/export-only-roas.json"})
    public JsonExportExtended exportJsonOnlyRoas(HttpServletResponse response) {
        response.setContentType(JSON);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return null;
        }
        return new JsonExportExtended(this.vrpExtendedStream());
    }

    @ApiOperation(value="export VRPs (CSV) extended with validity and serial number")
    @GetMapping(path={"/api/export-only-roas.csv"})
    public void exportCsvOnlyRoas(HttpServletResponse response) throws IOException {
        response.setContentType(CSV);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return;
        }
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            writer.writeNext(new String[]{"ASN", "IP Prefix", "Max Length", "Trust Anchor", "Not Valid Before", "Not Valid After", "Serial Number"});
            this.vrpExtendedStream().forEach(vrp -> writer.writeNext(new String[]{vrp.getAsn(), vrp.getPrefix(), String.valueOf(vrp.getMaxLength()), vrp.getTa(), vrp.getNotBefore(), vrp.getNotAfter(), vrp.getSerialNumber()}));
        }
    }

    private Stream<ExtendedRoa> vrpExtendedStream() {
        return this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes().getObjects().map(r -> new ExtendedRoa(String.valueOf(r.getAsn()), r.getPrefix().toString(), r.getEffectiveLength(), r.getTrustAnchor().getName(), Instant.ofEpochMilli(r.getNotBefore()).toString(), Instant.ofEpochMilli(r.getNotAfter()).toString(), r.getSerialNumber().toString())).distinct();
    }

    private Stream<VRP> vrpStream() {
        Stream<VRP> validatedPrefixes = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes().getObjects().filter(new IgnoreFiltersPredicate(this.ignoreFilters.all()).negate()).map(r -> new VRP(String.valueOf(r.getAsn()), r.getPrefix().toString(), r.getEffectiveLength(), r.getTrustAnchor().getName()));
        Stream<VRP> assertions = this.roaPrefixAssertions.all().map(assertion -> new VRP(assertion.getAsn().toString(), assertion.getPrefix().toString(), assertion.getMaxPrefixLength() != null ? assertion.getMaxPrefixLength().intValue() : assertion.getPrefix().getPrefixLength(), "SLURM"));
        return Stream.concat(validatedPrefixes, assertions).distinct();
    }
}

