/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roaprefixassertions;

import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.rpki.validator3.api.ApiCommand;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewController;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewService;
import net.ripe.rpki.validator3.api.roaprefixassertions.AddRoaPrefixAssertion;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertion;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionResource;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@PublicApiCall
@RestController
@Api(tags={"Whitelist"})
@RequestMapping(path={"/api/roa-prefix-assertions"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class RoaPrefixAssertionsController {
    private static final Logger log = LoggerFactory.getLogger(RoaPrefixAssertionsController.class);
    @Autowired
    private RoaPrefixAssertionsService roaPrefixAssertionsService;
    @Autowired
    private BgpPreviewService bgpPreviewService;

    @ApiOperation(value="Get current entries")
    @GetMapping
    public ResponseEntity<ApiResponse<Stream<RoaPrefixAssertionResource>>> list(@RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", defaultValue="", required=false) String searchString, @ApiParam(allowableValues="prefix, asn, ta, key, location, status, validity, type, lastchecked, comment, maximumlength") @RequestParam(name="sortBy", defaultValue="prefix") String sortBy, @ApiParam(allowableValues="asc, desc") @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection) {
        SearchTerm searchTerm = StringUtils.isNotBlank((String)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        List matching = this.roaPrefixAssertionsService.find(searchTerm, sorting, paging).collect(Collectors.toList());
        long totalSize = (int)this.roaPrefixAssertionsService.count(searchTerm);
        Links links = Paging.links((long)startFrom, (long)pageSize, (long)totalSize, (sf, ps) -> ((RoaPrefixAssertionsController)ControllerLinkBuilder.methodOn(RoaPrefixAssertionsController.class, (Object[])new Object[0])).list(sf.longValue(), ps.longValue(), searchString, sortBy, sortDirection));
        return ResponseEntity.ok((Object)ApiResponse.builder().links(links).metadata(Metadata.of((long)totalSize)).data(matching.stream().map(arg_0 -> this.toResource(arg_0))).build());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ApiResponse<RoaPrefixAssertionResource>> get(@PathVariable long id) {
        return ResponseEntity.ok((Object)ApiResponse.data((Object)this.toResource(this.roaPrefixAssertionsService.get(id))));
    }

    @ApiOperation(value="Add whitelist entry", notes="By adding a whitelist entry you can manually authorise an ASN to originate a prefix, in addition to the validated ROAs from the repository.\nPlease note that whitelist entries may invalidate announcements for this prefix from other ASNs (just like ROAs). This may be intentional (when you whitelist ASN A, which ASN B is hijacking), or not (when ASN B should also be authorised, or you made a mistake).\nWhen you modify the whitelist please validate its effects using `/api/roa-prefix-assertions` to find the number of prefixes validated and invalidated, and verify that there are no unintentional side-effects.")
    @PostMapping(consumes={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
    public ResponseEntity<ApiResponse<RoaPrefixAssertionResource>> add(@RequestBody @Valid ApiCommand<AddRoaPrefixAssertion> command) {
        long id = this.roaPrefixAssertionsService.execute((AddRoaPrefixAssertion)command.getData());
        RoaPrefixAssertion ignoreFilter = this.roaPrefixAssertionsService.get(id);
        Link selfRel = ControllerLinkBuilder.linkTo((Object)((RoaPrefixAssertionsController)ControllerLinkBuilder.methodOn(RoaPrefixAssertionsController.class, (Object[])new Object[0])).get(id)).withSelfRel();
        return ResponseEntity.created((URI)URI.create(selfRel.getHref())).body((Object)ApiResponse.data((Object)this.toResource(ignoreFilter)));
    }

    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable long id) {
        this.roaPrefixAssertionsService.remove(id);
        return ResponseEntity.noContent().build();
    }

    private RoaPrefixAssertionResource toResource(RoaPrefixAssertion assertion) {
        Long asn = assertion.getAsn();
        List affected = this.bgpPreviewService.findAffected(assertion.getPrefix(), assertion.getMaxPrefixLength());
        ImmutableList.Builder validated = ImmutableList.builder();
        ImmutableList.Builder invalidated = ImmutableList.builder();
        affected.forEach(x -> {
            BgpPreviewController.BgpPreview entry = BgpPreviewController.BgpPreview.of((String)x.getOrigin().toString(), (String)x.getPrefix().toString(), (String)x.getValidity().toString());
            if (x.getValidity() == BgpPreviewService.Validity.VALID && x.getOrigin().equals((Object)asn)) {
                validated.add((Object)entry);
            } else if (x.getValidity() != BgpPreviewService.Validity.VALID) {
                invalidated.add((Object)entry);
            }
        });
        return RoaPrefixAssertionResource.of((long)assertion.getId(), (long)assertion.getAsn(), (String)assertion.getPrefix().toString(), (Integer)assertion.getMaxPrefixLength(), (String)assertion.getComment(), (List)validated.build(), (List)invalidated.build());
    }
}

