/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.ripe.rpki.validator3.util.TrustAnchorExtractorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class TrustAnchorLocator {
    private final String caName;
    private final List<URI> certificateLocations;
    private final String publicKeyInfo;
    private final List<URI> prefetchUris;
    private URI fetchedCertificateUri;

    public static TrustAnchorLocator fromMultipartFile(MultipartFile file) throws TrustAnchorExtractorException {
        try {
            String contents = new String(file.getBytes(), Charsets.UTF_8);
            String trimmed = contents.trim();
            if (TrustAnchorLocator.looksLikeUri((String)trimmed)) {
                return TrustAnchorLocator.readStandardTrustAnchorLocator((String)file.getOriginalFilename(), (String)trimmed);
            }
            return TrustAnchorLocator.readExtendedTrustAnchorLocator((String)contents);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            throw new TrustAnchorExtractorException("failed to load trust anchor locator " + file + ": " + e.getMessage(), e);
        }
    }

    public static TrustAnchorLocator fromFile(File file) throws TrustAnchorExtractorException {
        try {
            String contents = Files.toString((File)file, (Charset)Charsets.UTF_8);
            String trimmed = contents.trim();
            if (TrustAnchorLocator.looksLikeUri((String)trimmed)) {
                return TrustAnchorLocator.readStandardTrustAnchorLocator((String)file.getName(), (String)trimmed);
            }
            return TrustAnchorLocator.readExtendedTrustAnchorLocator((String)trimmed);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            throw new TrustAnchorExtractorException("failed to load trust anchor locator " + file + ": " + e.getMessage(), e);
        }
    }

    private static TrustAnchorLocator readStandardTrustAnchorLocator(String fileName, String contents) throws URISyntaxException, IOException {
        String caName = fileName;
        ArrayList<URI> certificateLocations = new ArrayList<URI>();
        try (BufferedReader reader = new BufferedReader(new StringReader(contents));){
            String trimmed;
            String line;
            while ((line = reader.readLine()) != null && TrustAnchorLocator.looksLikeUri((String)(trimmed = line.trim()))) {
                certificateLocations.add(new URI(trimmed));
            }
            if (line == null) {
                throw new IllegalArgumentException("publicKeyInfo not found in TAL file " + fileName);
            }
            StringBuilder publicKeyInfo = new StringBuilder(line.trim());
            while ((line = reader.readLine()) != null) {
                publicKeyInfo.append(line.trim());
            }
            TrustAnchorLocator trustAnchorLocator = new TrustAnchorLocator(caName, certificateLocations, publicKeyInfo.toString(), Collections.emptyList());
            return trustAnchorLocator;
        }
    }

    private static boolean looksLikeUri(String string) {
        return string.startsWith("rsync://") || string.startsWith("https://") || string.startsWith("http://");
    }

    private static TrustAnchorLocator readExtendedTrustAnchorLocator(String contents) throws IOException, URISyntaxException {
        Properties p = new Properties();
        p.load(new StringReader(contents));
        String caName = p.getProperty("ca.name");
        String loc = p.getProperty("certificate.location");
        Validate.notEmpty((String)loc, (String)"'certificate.location' must be provided");
        URI location = new URI(loc);
        String publicKeyInfo = p.getProperty("public.key.info", "").replaceAll("\\s+", "");
        String[] uris = p.getProperty("prefetch.uris", "").split(",");
        ArrayList<URI> prefetchUris = new ArrayList<URI>(uris.length);
        for (String uri : uris) {
            if (!StringUtils.isNotBlank((String)(uri = uri.trim()))) continue;
            if (!uri.endsWith("/") && uri.startsWith("rsync://")) {
                uri = uri + "/";
            }
            prefetchUris.add(new URI(uri));
        }
        return new TrustAnchorLocator(caName, Collections.singletonList(location), publicKeyInfo, prefetchUris);
    }

    public TrustAnchorLocator(String caName, List<URI> location, String publicKeyInfo, List<URI> prefetchUris) {
        Validate.notEmpty((String)caName, (String)"'ca.name' must be provided");
        Validate.notNull(location, (String)"'certificate.location' must be provided");
        Validate.notEmpty((String)publicKeyInfo, (String)"'public.key.info' must be provided");
        this.caName = caName;
        this.certificateLocations = location;
        this.publicKeyInfo = publicKeyInfo;
        this.prefetchUris = prefetchUris;
    }

    public String getCaName() {
        return this.caName;
    }

    public List<URI> getCertificateLocations() {
        return this.certificateLocations;
    }

    public String getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public List<URI> getPrefetchUris() {
        return this.prefetchUris;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("caName", (Object)this.getCaName()).add("certificationLocation", (Object)Joiner.on((String)", ").join((Iterable)this.getCertificateLocations())).toString();
    }

    public URI getFetchedCertificateUri() {
        return this.fetchedCertificateUri;
    }

    public void setFetchedCertificateUri(URI fetchedCertificateUri) {
        this.fetchedCertificateUri = fetchedCertificateUri;
    }
}

