/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import net.ripe.rpki.validator3.api.ApiLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.Links;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class ApiConfig
implements WebMvcConfigurer {
    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer includeNonNullOnly() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizeLinksRendering() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializerByType(Links.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
            jacksonObjectMapperBuilder.deserializerByType(Links.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        };
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(this.objectMapper);
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.valueOf((String)"text/json")));
        converter.setPrettyPrint(true);
        converters.add((HttpMessageConverter<?>)converter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false).defaultContentType(new MediaType[]{MediaType.valueOf((String)"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8")});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ApiLogger()).addPathPatterns(new String[]{"/api/**"});
    }
}

