/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.validationruns;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.api.validationruns.ValidationCheckResource;
import net.ripe.rpki.validator3.api.validationruns.ValidationRunController;
import net.ripe.rpki.validator3.api.validationruns.ValidationRunResource;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import org.springframework.context.MessageSource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@ApiModel(value="ValidationRun", description="The result of a validation run (at a point in time) of the validator.")
public class ValidationRunResource {
    @ApiModelProperty(allowableValues="trust-anchor-validation-run,rrdp-repository-validation-run,rsync-repository-validation-run", required=true, position=1)
    String type;
    InstantWithoutNanos startedAt;
    InstantWithoutNanos completedAt;
    @ApiModelProperty(allowableValues="RUNNING, SUCCEEDED, FAILED", example="SUCCEEDED")
    String status;
    List<ValidationCheckResource> validationChecks;
    Integer validatedObjectCount;
    Integer addedObjectCount;
    Links links;

    public static ValidationRunResource of(ValidationRun validationRun, Function<ValidationRun, Integer> objectCounter, MessageSource messageSource, Locale locale) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo((Object)((ValidationRunController)ControllerLinkBuilder.methodOn(ValidationRunController.class, (Object[])new Object[0])).get(validationRun.key().asLong(), locale)).withSelfRel());
        ValidationRunResourceBuilder builder = ValidationRunResource.builder().type(validationRun.getType()).startedAt(validationRun.getCreatedAt()).completedAt(validationRun.getCompletedAt()).status(validationRun.getStatus().name()).validationChecks(validationRun.getValidationChecks().stream().map(check -> ValidationCheckResource.of((ValidationCheck)check, (String)check.formattedMessage(messageSource, locale))).collect(Collectors.toList()));
        validationRun.visit((ValidationRun.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        return builder.links(new Links(links)).build();
    }

    @ConstructorProperties(value={"type", "startedAt", "completedAt", "status", "validationChecks", "validatedObjectCount", "addedObjectCount", "links"})
    ValidationRunResource(String type, InstantWithoutNanos startedAt, InstantWithoutNanos completedAt, String status, List<ValidationCheckResource> validationChecks, Integer validatedObjectCount, Integer addedObjectCount, Links links) {
        this.type = type;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.status = status;
        this.validationChecks = validationChecks;
        this.validatedObjectCount = validatedObjectCount;
        this.addedObjectCount = addedObjectCount;
        this.links = links;
    }

    public static ValidationRunResourceBuilder builder() {
        return new ValidationRunResourceBuilder();
    }

    private ValidationRunResource() {
    }

    public String getType() {
        return this.type;
    }

    public InstantWithoutNanos getStartedAt() {
        return this.startedAt;
    }

    public InstantWithoutNanos getCompletedAt() {
        return this.completedAt;
    }

    public String getStatus() {
        return this.status;
    }

    public List<ValidationCheckResource> getValidationChecks() {
        return this.validationChecks;
    }

    public Integer getValidatedObjectCount() {
        return this.validatedObjectCount;
    }

    public Integer getAddedObjectCount() {
        return this.addedObjectCount;
    }

    public Links getLinks() {
        return this.links;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStartedAt(InstantWithoutNanos startedAt) {
        this.startedAt = startedAt;
    }

    public void setCompletedAt(InstantWithoutNanos completedAt) {
        this.completedAt = completedAt;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setValidationChecks(List<ValidationCheckResource> validationChecks) {
        this.validationChecks = validationChecks;
    }

    public void setValidatedObjectCount(Integer validatedObjectCount) {
        this.validatedObjectCount = validatedObjectCount;
    }

    public void setAddedObjectCount(Integer addedObjectCount) {
        this.addedObjectCount = addedObjectCount;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationRunResource)) {
            return false;
        }
        ValidationRunResource other = (ValidationRunResource)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        InstantWithoutNanos this$startedAt = this.getStartedAt();
        InstantWithoutNanos other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !this$startedAt.equals(other$startedAt)) {
            return false;
        }
        InstantWithoutNanos this$completedAt = this.getCompletedAt();
        InstantWithoutNanos other$completedAt = other.getCompletedAt();
        if (this$completedAt == null ? other$completedAt != null : !this$completedAt.equals(other$completedAt)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List this$validationChecks = this.getValidationChecks();
        List other$validationChecks = other.getValidationChecks();
        if (this$validationChecks == null ? other$validationChecks != null : !((Object)this$validationChecks).equals(other$validationChecks)) {
            return false;
        }
        Integer this$validatedObjectCount = this.getValidatedObjectCount();
        Integer other$validatedObjectCount = other.getValidatedObjectCount();
        if (this$validatedObjectCount == null ? other$validatedObjectCount != null : !((Object)this$validatedObjectCount).equals(other$validatedObjectCount)) {
            return false;
        }
        Integer this$addedObjectCount = this.getAddedObjectCount();
        Integer other$addedObjectCount = other.getAddedObjectCount();
        if (this$addedObjectCount == null ? other$addedObjectCount != null : !((Object)this$addedObjectCount).equals(other$addedObjectCount)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationRunResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        InstantWithoutNanos $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : $startedAt.hashCode());
        InstantWithoutNanos $completedAt = this.getCompletedAt();
        result = result * 59 + ($completedAt == null ? 43 : $completedAt.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List $validationChecks = this.getValidationChecks();
        result = result * 59 + ($validationChecks == null ? 43 : ((Object)$validationChecks).hashCode());
        Integer $validatedObjectCount = this.getValidatedObjectCount();
        result = result * 59 + ($validatedObjectCount == null ? 43 : ((Object)$validatedObjectCount).hashCode());
        Integer $addedObjectCount = this.getAddedObjectCount();
        result = result * 59 + ($addedObjectCount == null ? 43 : ((Object)$addedObjectCount).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    public String toString() {
        return "ValidationRunResource(type=" + this.getType() + ", startedAt=" + this.getStartedAt() + ", completedAt=" + this.getCompletedAt() + ", status=" + this.getStatus() + ", validationChecks=" + this.getValidationChecks() + ", validatedObjectCount=" + this.getValidatedObjectCount() + ", addedObjectCount=" + this.getAddedObjectCount() + ", links=" + this.getLinks() + ")";
    }
}

