/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.rpkirepositories;

import javax.annotation.PostConstruct;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class RpkiRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(RpkiRepositoryService.class);
    private final RpkiRepositories rpkiRepositories;
    private final ValidationScheduler validationScheduler;
    private final Storage storage;

    @Autowired
    public RpkiRepositoryService(RpkiRepositories rpkiRepositories, ValidationScheduler validationScheduler, Storage storage) {
        this.rpkiRepositories = rpkiRepositories;
        this.validationScheduler = validationScheduler;
        this.storage = storage;
    }

    @PostConstruct
    public void scheduleRpkiRepositoryValidation() {
        log.info("Schedule RPKI validation for the existing repositories");
        this.storage.writeTx0(tx -> this.rpkiRepositories.findRrdpRepositories((Tx.Read)tx).forEach(r -> {
            tx.afterCommit(() -> this.validationScheduler.addRrdpRpkiRepository(r));
            log.info("Scheduled {} for validation.", r);
        }));
    }
}

