/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.validation.constraints.NotNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.validator3.api.bgp.BgpRisDownloader;
import net.ripe.rpki.validator3.api.bgp.BgpRisDump;
import net.ripe.rpki.validator3.api.bgp.BgpRisEntry;
import net.ripe.rpki.validator3.util.Http;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BgpRisDownloader {
    private static final Logger log = LoggerFactory.getLogger(BgpRisDownloader.class);
    private final Http http;
    private HttpClient httpClient;
    private static Pattern regexp = Pattern.compile("^\\s*([0-9]+)\\s+([0-9a-fA-F.:/]+)\\s+([0-9]+)\\s*$");

    @Autowired
    public BgpRisDownloader(Http http) {
        this.http = http;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.httpClient = this.http.client();
        this.httpClient.start();
    }

    @PreDestroy
    public void preDestory() throws Exception {
        this.httpClient.stop();
    }

    public BgpRisDump fetch(@NotNull BgpRisDump dump) {
        log.info("attempting to download new BGP RIS preview dump from {}", (Object)dump.url);
        Supplier<Request> requestSupplier = () -> {
            Request request = this.httpClient.newRequest(dump.url);
            if (dump.lastModified != null) {
                log.debug("Adding 'If-Modified-Since' equals to {}", (Object)this.formatAsRFC2616(dump.lastModified));
                request.header("If-Modified-Since", this.formatAsRFC2616(dump.lastModified));
            }
            return request;
        };
        BiFunction<InputStream, Long, BgpRisDump> streamReader = (stream, lastModified) -> {
            try {
                List entries = BgpRisDownloader.parse((InputStream)new GZIPInputStream((InputStream)stream));
                return BgpRisDump.of((String)dump.url, (DateTime)new DateTime(lastModified), Optional.of(entries));
            }
            catch (Exception e) {
                log.error("Error downloading RIS dump: " + dump.url);
                return dump;
            }
        };
        try {
            return (BgpRisDump)Http.readStream(requestSupplier, streamReader);
        }
        catch (Http.NotModified n) {
            return dump;
        }
    }

    public static List<BgpRisEntry> parse(InputStream is) {
        IdentityMap id = new IdentityMap(null);
        return new BufferedReader(new InputStreamReader(is)).lines().map(s -> {
            try {
                return BgpRisDownloader.parseLine((String)s, arg_0 -> ((IdentityMap)id).unique(arg_0));
            }
            catch (Exception e) {
                log.error("Unparseable line: " + s);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BgpRisEntry parseLine(String line, Function<Object, Object> uniq) {
        Matcher matcher = regexp.matcher(line);
        if (matcher.matches()) {
            Asn asn = (Asn)uniq.apply(Asn.parse((String)matcher.group(1)));
            IpRange parsed = IpRange.parse((String)matcher.group(2));
            UniqueIpResource start = (UniqueIpResource)uniq.apply(parsed.getStart());
            UniqueIpResource end = (UniqueIpResource)uniq.apply(parsed.getEnd());
            IpRange prefix = (IpRange)start.upTo(end);
            int visibility = Integer.parseInt(matcher.group(3));
            return BgpRisEntry.of((Asn)asn, (IpRange)prefix, (int)visibility);
        }
        return null;
    }

    private String formatAsRFC2616(DateTime d) {
        return d.toDateTime(DateTimeZone.UTC).toString("EEE, dd MMM yyyy HH:mm:ss ZZZ");
    }
}

