/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.util.Bench;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class Bench {
    private String namespace;
    private static Map<String, Bench> benches = new HashMap();
    private final Map<String, Record> records = new HashMap();

    private Bench(String namespace) {
        this.namespace = namespace;
    }

    public static Bench create(String namespace) {
        return new Bench(namespace);
    }

    public static <T> T mark(String namespace, String tag, Supplier<T> s) {
        return (T)Bench.getBench((String)namespace).measure(tag, s);
    }

    public static void mark0(String namespace, String tag, Runnable r) {
        Bench.getBench((String)namespace).measure0(tag, r);
    }

    public static <T> T mark(String tag, Supplier<T> s) {
        return (T)Bench.mark((String)"global", (String)tag, s);
    }

    public static void mark0(String tag, Runnable r) {
        Bench.mark0((String)"global", (String)tag, (Runnable)r);
    }

    @NotNull
    private static synchronized Bench getBench(String namespace) {
        Bench bench = (Bench)benches.get(namespace);
        if (bench == null) {
            bench = new Bench(namespace);
            benches.put(namespace, bench);
        }
        return bench;
    }

    private void measure0(String tag, Runnable r) {
        this.measure(tag, () -> {
            r.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T measure(String tag, Supplier<T> s) {
        long b = System.nanoTime();
        T v = s.get();
        long e = System.nanoTime();
        long time = e - b;
        Map map = this.records;
        synchronized (map) {
            Record r = (Record)this.records.get(tag);
            if (r == null) {
                this.records.put(tag, new Record(1L, time, time, time));
            } else {
                this.records.put(tag, new Record(r.count + 1L, r.totalTime + time, Math.min(r.minTime, time), Math.max(r.maxTime, time)));
            }
        }
        return v;
    }

    public static String dump(String namespace) {
        return Bench.getBench((String)namespace).dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dump() {
        Map map = this.records;
        synchronized (map) {
            String s = this.records.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> {
                Record r = (Record)e.getValue();
                StringBuilder sb = new StringBuilder(this.namespace).append("# ").append((String)e.getKey()).append(": ");
                sb.append("max = ").append(Bench.asMs((long)r.maxTime));
                sb.append(", min = ").append(Bench.asMs((long)r.minTime));
                sb.append(", full total = ").append(Bench.asMs((long)r.totalTime));
                sb.append(", count = ").append(r.count);
                sb.append(", avg = ").append(Bench.avgAsMs((long)r.totalTime, (long)r.count));
                return sb.toString();
            }).collect(Collectors.joining("\n"));
            this.records.clear();
            return s;
        }
    }

    private static String avgAsMs(long total, long n) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return formatter.format((double)total / 1000000.0 / (double)n);
    }

    private static String asMs(long nanoSeconds) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return formatter.format((double)nanoSeconds / 1000000.0);
    }
}

