/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.jobs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.domain.validation.CertificateTreeValidationService;
import net.ripe.rpki.validator3.domain.validation.RpkiRepositoryValidationService;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorValidationService;
import net.ripe.rpki.validator3.jobs.JobExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JobExecutor {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final TrustAnchorValidationService trustAnchorValidationService;
    private final CertificateTreeValidationService certificateTreeValidationService;
    private final RpkiRepositoryValidationService rpkiRepositoryValidationService;
    private final Map<QueueId, List<Job>> jobs = new HashMap();
    private AtomicLong idSeq = new AtomicLong(1L);
    private final Set<Long> currentlyExecuted = new HashSet();

    @Autowired
    public JobExecutor(TrustAnchorValidationService trustAnchorValidationService, CertificateTreeValidationService certificateTreeValidationService, RpkiRepositoryValidationService rpkiRepositoryValidationService) {
        this.trustAnchorValidationService = trustAnchorValidationService;
        this.certificateTreeValidationService = certificateTreeValidationService;
        this.rpkiRepositoryValidationService = rpkiRepositoryValidationService;
    }

    public Job taValidation(long trustAnchorId) {
        return new Job(this.idSeq.getAndIncrement(), QueueId.of((String)("trustAnchor:" + trustAnchorId)), Type.TA_VALIDATION, () -> this.trustAnchorValidationService.validate(trustAnchorId));
    }

    public Job certificateTreeValidation(long trustAnchorId) {
        return new Job(this.idSeq.getAndIncrement(), QueueId.of((String)("trustAnchor:" + trustAnchorId)), Type.CAT_VALIDATION, () -> this.certificateTreeValidationService.validate(trustAnchorId));
    }

    public Job rrdpRepoValidation(long repositoryId) {
        return new Job(this.idSeq.getAndIncrement(), QueueId.of((String)("rrdp:" + repositoryId)), Type.RRDP_VALIDATION, () -> this.rpkiRepositoryValidationService.validateRrdpRpkiRepository(repositoryId));
    }

    public void repeat(Job job, Duration duration) {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.submit(job), 0L, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Job job) {
        Map map = this.jobs;
        synchronized (map) {
            ArrayList<Job> queue = (ArrayList<Job>)this.jobs.get(job.getQueueId());
            if (queue == null) {
                queue = new ArrayList<Job>();
                queue.add(job);
                this.jobs.put(job.getQueueId(), queue);
            } else if (queue.stream().noneMatch(j -> j.getType() == job.getType())) {
                queue.add(job);
                this.jobs.put(job.getQueueId(), queue);
            }
            this.executor.submit(() -> {
                Map map = this.jobs;
                synchronized (map) {
                    this.jobs.values().stream().findFirst().ifPresent(q -> q.stream().findFirst().ifPresent(j -> {}));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequence(Job ... newJobs) {
        Map map = this.jobs;
        synchronized (map) {
            Stream.of(newJobs).forEach(arg_0 -> this.submit(arg_0));
        }
    }
}

