/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RpkiRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import org.apache.commons.lang3.tuple.Pair;

public interface ValidationRuns {
    public <T extends ValidationRun> T add(Tx.Write var1, T var2);

    public <T extends ValidationRun> void update(Tx.Write var1, T var2);

    public <T extends ValidationRun> Optional<T> get(Tx.Read var1, Class<T> var2, long var3);

    public <T extends ValidationRun> List<T> findAll(Tx.Read var1, Class<T> var2);

    public <T extends ValidationRun> List<T> findLatestSuccessful(Tx.Read var1, Class<T> var2);

    public Optional<CertificateTreeValidationRun> findLatestSuccessfulCaTreeValidationRun(Tx.Read var1, TrustAnchor var2);

    public Optional<TrustAnchorValidationRun> findLatestCompletedForTrustAnchor(Tx.Read var1, TrustAnchor var2);

    public Optional<CertificateTreeValidationRun> findLatestCaTreeValidationRun(Tx.Read var1, TrustAnchor var2);

    public int removeOldValidationRuns(Tx.Write var1, Instant var2);

    public Stream<ValidationCheck> findValidationChecksForValidationRun(Tx.Read var1, long var2, Paging var4, SearchTerm var5, Sorting var6);

    public int countValidationChecksForValidationRun(Tx.Read var1, long var2, SearchTerm var4);

    public void associate(Tx.Write var1, RpkiRepositoryValidationRun var2, RpkiObject var3);

    public void associate(Tx.Write var1, RpkiRepositoryValidationRun var2, RpkiRepository var3);

    public void associateRpkiObjectKey(Tx.Write var1, CertificateTreeValidationRun var2, Key var3);

    public Set<Key> findAssociatedPks(Tx.Read var1, CertificateTreeValidationRun var2);

    public Stream<Pair<CertificateTreeValidationRun, RpkiObject>> findCurrentlyValidated(Tx.Read var1, RpkiObject.Type var2);

    public void clear(Tx.Write var1);

    public int getObjectCount(Tx.Read var1, ValidationRun var2);

    public int removeOrphanValidationRunAssociations(Tx.Write var1);
}

