/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RoaPrefix;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.util.Bench;
import net.ripe.rpki.validator3.util.Sha256;
import org.joda.time.DateTime;

@Binary
public class RpkiObject
extends Base<RpkiObject> {
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 0xA00000;
    @NotNull
    private Type type;
    private BigInteger serialNumber;
    private Instant signingTime;
    private byte[] authorityKeyIdentifier;
    @NotNull
    private byte[] sha256;
    @NotNull
    private byte[] encoded;
    @NotNull
    @Valid
    private List<RoaPrefix> roaPrefixes = new ArrayList();

    public Key key() {
        return Key.of((byte[])this.sha256);
    }

    public RpkiObject() {
    }

    public RpkiObject(CertificateRepositoryObject object) {
        byte[] encoded = object.getEncoded();
        this.sha256 = Sha256.hash((byte[])encoded);
        this.encoded = encoded;
        if (object instanceof X509ResourceCertificate) {
            this.serialNumber = ((X509ResourceCertificate)object).getSerialNumber();
            this.signingTime = null;
            this.authorityKeyIdentifier = ((X509ResourceCertificate)object).getAuthorityKeyIdentifier();
            this.type = Type.CER;
        } else if (object instanceof X509RouterCertificate) {
            this.serialNumber = ((X509RouterCertificate)object).getSerialNumber();
            this.signingTime = null;
            this.authorityKeyIdentifier = ((X509RouterCertificate)object).getAuthorityKeyIdentifier();
            this.type = Type.ROUTER_CER;
        } else if (object instanceof X509Crl) {
            this.serialNumber = ((X509Crl)object).getNumber();
            DateTime signingTime = ((X509Crl)object).getThisUpdateTime();
            this.signingTime = signingTime != null ? Instant.ofEpochMilli(signingTime.getMillis()) : null;
            this.authorityKeyIdentifier = ((X509Crl)object).getAuthorityKeyIdentifier();
            this.type = Type.CRL;
        } else if (object instanceof RpkiSignedObject) {
            this.serialNumber = ((RpkiSignedObject)object).getCertificate().getSerialNumber();
            DateTime signingTime = ((RpkiSignedObject)object).getSigningTime();
            this.signingTime = signingTime != null ? Instant.ofEpochMilli(signingTime.getMillis()) : null;
            this.authorityKeyIdentifier = ((RpkiSignedObject)object).getCertificate().getAuthorityKeyIdentifier();
            if (object instanceof ManifestCms) {
                this.type = Type.MFT;
                this.serialNumber = ((ManifestCms)object).getNumber();
            } else if (object instanceof RoaCms) {
                RoaCms roaCms = (RoaCms)object;
                this.type = Type.ROA;
                this.roaPrefixes = roaCms.getPrefixes().stream().map(prefix -> RoaPrefix.of((IpRange)prefix.getPrefix(), (Integer)prefix.getMaximumLength(), (Asn)roaCms.getAsn())).collect(Collectors.toList());
            } else {
                this.type = object instanceof GhostbustersCms ? Type.GBR : Type.OTHER;
            }
        } else {
            if (object instanceof UnknownCertificateRepositoryObject) {
                throw new IllegalArgumentException("unsupported certificate repository object type " + object);
            }
            throw new IllegalArgumentException("unsupported certificate repository object type " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CertificateRepositoryObject> Optional<T> get(Class<T> clazz, ValidationResult validationResult) {
        ValidationResult temporary = ValidationResult.withLocation((ValidationLocation)validationResult.getCurrentLocation());
        try {
            Optional optional = this.get(clazz, validationResult.getCurrentLocation().getName());
            return optional;
        }
        finally {
            validationResult.addAll(temporary);
        }
    }

    public <T extends CertificateRepositoryObject> Optional<T> get(Class<T> clazz, String location) {
        ValidationResult temporary = ValidationResult.withLocation((String)location);
        ValidationResult ignored = ValidationResult.withLocation((String)location);
        CertificateRepositoryObject candidate = (CertificateRepositoryObject)Bench.mark((String)"createCertificateRepositoryObject", () -> CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])this.encoded, (ValidationResult)ignored));
        temporary.rejectIfNull((Object)candidate, "rpki.object.parsable", new String[0]);
        if (temporary.hasFailureForCurrentLocation()) {
            return Optional.empty();
        }
        boolean isNeededInstance = clazz.isInstance(candidate);
        if (!isNeededInstance) {
            temporary.rejectIfFalse(isNeededInstance, "rpki.object.type.matches", new String[]{clazz.getSimpleName(), candidate.getClass().getSimpleName()});
            if (temporary.hasFailureForCurrentLocation()) {
                return Optional.empty();
            }
        }
        return Optional.of(clazz.cast(candidate));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpkiObject)) {
            return false;
        }
        RpkiObject other = (RpkiObject)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BigInteger this$serialNumber = this.getSerialNumber();
        BigInteger other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !((Object)this$serialNumber).equals(other$serialNumber)) {
            return false;
        }
        Instant this$signingTime = this.getSigningTime();
        Instant other$signingTime = other.getSigningTime();
        if (this$signingTime == null ? other$signingTime != null : !((Object)this$signingTime).equals(other$signingTime)) {
            return false;
        }
        if (!Arrays.equals(this.getAuthorityKeyIdentifier(), other.getAuthorityKeyIdentifier())) {
            return false;
        }
        if (!Arrays.equals(this.getSha256(), other.getSha256())) {
            return false;
        }
        if (!Arrays.equals(this.getEncoded(), other.getEncoded())) {
            return false;
        }
        List this$roaPrefixes = this.getRoaPrefixes();
        List other$roaPrefixes = other.getRoaPrefixes();
        return !(this$roaPrefixes == null ? other$roaPrefixes != null : !((Object)this$roaPrefixes).equals(other$roaPrefixes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpkiObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BigInteger $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : ((Object)$serialNumber).hashCode());
        Instant $signingTime = this.getSigningTime();
        result = result * 59 + ($signingTime == null ? 43 : ((Object)$signingTime).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAuthorityKeyIdentifier());
        result = result * 59 + Arrays.hashCode(this.getSha256());
        result = result * 59 + Arrays.hashCode(this.getEncoded());
        List $roaPrefixes = this.getRoaPrefixes();
        result = result * 59 + ($roaPrefixes == null ? 43 : ((Object)$roaPrefixes).hashCode());
        return result;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Instant getSigningTime() {
        return this.signingTime;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public byte[] getSha256() {
        return this.sha256;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public List<RoaPrefix> getRoaPrefixes() {
        return this.roaPrefixes;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSigningTime(Instant signingTime) {
        this.signingTime = signingTime;
    }

    public void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public void setSha256(byte[] sha256) {
        this.sha256 = sha256;
    }

    public void setEncoded(byte[] encoded) {
        this.encoded = encoded;
    }

    public void setRoaPrefixes(List<RoaPrefix> roaPrefixes) {
        this.roaPrefixes = roaPrefixes;
    }

    public String toString() {
        return "RpkiObject(super=" + super.toString() + ", type=" + this.getType() + ", serialNumber=" + this.getSerialNumber() + ", signingTime=" + this.getSigningTime() + ", authorityKeyIdentifier=" + Arrays.toString(this.getAuthorityKeyIdentifier()) + ", sha256=" + Arrays.toString(this.getSha256()) + ", roaPrefixes=" + this.getRoaPrefixes() + ")";
    }

    public Type getType() {
        return this.type;
    }
}

