/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.CommandExecutionException;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.validation.RpkiRepositoryValidationService;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TrustAnchorValidationService {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorValidationService.class);
    private final TrustAnchors trustAnchors;
    private final RpkiRepositories rpkiRepositories;
    private final ValidationRuns validationRuns;
    private final ValidationScheduler validationScheduler;
    private final File localRsyncStorageDirectory;
    private final RpkiRepositoryValidationService repositoryValidationService;
    private final Storage storage;
    private Set<Key> validatedAtLeastOnce = Collections.newSetFromMap(new ConcurrentHashMap());

    @Autowired
    public TrustAnchorValidationService(TrustAnchors trustAnchors, RpkiRepositories rpkiRepositories, ValidationRuns validationRuns, ValidationScheduler validationScheduler, @Value(value="${rpki.validator.rsync.local.storage.directory}") File localRsyncStorageDirectory, RpkiRepositoryValidationService repositoryValidationService, Storage storage) {
        this.trustAnchors = trustAnchors;
        this.rpkiRepositories = rpkiRepositories;
        this.validationRuns = validationRuns;
        this.validationScheduler = validationScheduler;
        this.localRsyncStorageDirectory = localRsyncStorageDirectory;
        this.repositoryValidationService = repositoryValidationService;
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(long trustAnchorId) {
        Optional maybeTrustAnchor = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)trustAnchorId)));
        if (!maybeTrustAnchor.isPresent()) {
            log.error("Trust anchor {} doesn't exist.", (Object)trustAnchorId);
            return;
        }
        TrustAnchor trustAnchor = (TrustAnchor)maybeTrustAnchor.get();
        log.info("trust anchor {} located at {} with subject public key info {}", new Object[]{trustAnchor.getName(), trustAnchor.getLocations(), trustAnchor.getSubjectPublicKeyInfo()});
        TrustAnchorValidationRun validationRun = (TrustAnchorValidationRun)this.storage.readTx(tx -> {
            Ref trustAnchorRef = this.trustAnchors.makeRef(tx, Key.of((long)trustAnchorId));
            return new TrustAnchorValidationRun(trustAnchorRef, (String)trustAnchor.getLocations().get(0));
        });
        boolean updatedTrustAnchor = false;
        try {
            URI trustAnchorCertificateURI = URI.create(validationRun.getTrustAnchorCertificateURI()).normalize();
            ValidationResult validationResult = ValidationResult.withLocation((URI)trustAnchorCertificateURI);
            File targetFile = this.fetchTrustAnchorCertificate(trustAnchorCertificateURI, validationResult);
            if (!validationResult.hasFailureForCurrentLocation()) {
                long trustAnchorCertificateSize = targetFile.length();
                if (trustAnchorCertificateSize < 1L) {
                    validationResult.error("repository.object.minimum.size", new String[]{trustAnchorCertificateURI.toASCIIString(), String.valueOf(trustAnchorCertificateSize), String.valueOf(1)});
                } else if (trustAnchorCertificateSize > 0xA00000L) {
                    validationResult.error("repository.object.maximum.size", new String[]{trustAnchorCertificateURI.toASCIIString(), String.valueOf(trustAnchorCertificateSize), String.valueOf(0xA00000)});
                } else {
                    X509ResourceCertificate parsedCertificate = this.parseCertificate(trustAnchor, targetFile, validationResult);
                    if (!validationResult.hasFailureForCurrentLocation()) {
                        int comparedSerial = trustAnchor.getCertificate() == null ? 1 : parsedCertificate.getSerialNumber().compareTo(trustAnchor.getCertificate().getSerialNumber());
                        validationResult.warnIfTrue(comparedSerial < 0, "repository.object.is.older.than.previous.object", new String[]{trustAnchorCertificateURI.toASCIIString()});
                        if (comparedSerial != 0) {
                            log.info("Setting certificate {} for the TA {}", (Object)trustAnchorCertificateURI, (Object)trustAnchor.getName());
                            trustAnchor.setCertificate(parsedCertificate);
                            updatedTrustAnchor = true;
                        }
                    }
                }
            }
            if (validationResult.hasFailures()) {
                log.warn("Validation result for the TA {} has failures: {}", (Object)trustAnchor.getName(), (Object)validationResult.getFailures(new ValidationLocation(trustAnchorCertificateURI)));
            }
            validationRun.completeWith(validationResult);
            if (!this.validatedAtLeastOnce.contains(trustAnchor.getId()) || updatedTrustAnchor) {
                if (updatedTrustAnchor) {
                    this.storage.writeTx0(tx -> this.trustAnchors.update(tx, trustAnchor));
                }
                HashSet affectedTrustAnchors = Sets.newHashSet((Object[])new TrustAnchor[]{trustAnchor});
                if (trustAnchor.getRsyncPrefetchUri() != null) {
                    ((Optional)this.storage.readTx(tx -> this.rpkiRepositories.findByURI(tx, trustAnchor.getRsyncPrefetchUri()))).ifPresent(r -> affectedTrustAnchors.addAll(this.repositoryValidationService.prefetchRepository(r)));
                }
                affectedTrustAnchors.forEach(arg_0 -> ((ValidationScheduler)this.validationScheduler).triggerCertificateTreeValidation(arg_0));
            }
        }
        catch (IOException | CommandExecutionException e) {
            log.error("validation run for trust anchor {} failed", (Object)trustAnchor, (Object)e);
            validationRun.addCheck(new ValidationCheck(validationRun.getTrustAnchorCertificateURI(), ValidationCheck.Status.ERROR, "unhandled.exception", new String[]{e.toString()}));
            validationRun.setFailed();
        }
        finally {
            this.validatedAtLeastOnce.add(trustAnchor.getId());
            this.storage.writeTx0(tx -> {
                TrustAnchorValidationRun cfr_ignored_0 = (TrustAnchorValidationRun)this.validationRuns.add(tx, (ValidationRun)validationRun);
            });
        }
    }

    private X509ResourceCertificate parseCertificate(TrustAnchor trustAnchor, File certificateFile, ValidationResult validationResult) throws IOException {
        boolean signatureValid;
        CertificateRepositoryObject trustAnchorCertificate = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])Files.toByteArray((File)certificateFile), (ValidationResult)validationResult);
        validationResult.rejectIfFalse(trustAnchorCertificate instanceof X509ResourceCertificate, "repository.object.is.trust.anchor.certificate", new String[]{trustAnchor.getRsyncPrefetchUri()});
        if (validationResult.hasFailureForCurrentLocation()) {
            return null;
        }
        X509ResourceCertificate certificate = (X509ResourceCertificate)trustAnchorCertificate;
        String encodedSubjectPublicKeyInfo = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
        validationResult.rejectIfFalse(encodedSubjectPublicKeyInfo.equals(trustAnchor.getSubjectPublicKeyInfo()), "trust.anchor.subject.key.matches.locator", new String[0]);
        try {
            certificate.getCertificate().verify(certificate.getPublicKey());
            signatureValid = true;
        }
        catch (GeneralSecurityException e) {
            signatureValid = false;
        }
        validationResult.rejectIfFalse(signatureValid, "trust.anchor.signature", new String[]{trustAnchor.getRsyncPrefetchUri(), trustAnchor.getSubjectPublicKeyInfo()});
        return certificate;
    }

    private File fetchTrustAnchorCertificate(URI trustAnchorCertificateURI, ValidationResult validationResult) throws IOException {
        File targetFile = net.ripe.rpki.validator3.util.Rsync.localFileFromRsyncUri((File)this.localRsyncStorageDirectory, (URI)trustAnchorCertificateURI);
        if (targetFile.getParentFile().mkdirs()) {
            log.info("created local rsync storage directory {} for trust anchor {}", (Object)targetFile.getParentFile(), (Object)trustAnchorCertificateURI);
        }
        Rsync rsync = new Rsync(trustAnchorCertificateURI.toASCIIString(), targetFile.getPath());
        rsync.addOptions(new String[]{"--update", "--times", "--copy-links"});
        int exitStatus = rsync.execute();
        if (exitStatus != 0) {
            validationResult.error("rsync.fetch", new String[]{String.valueOf(exitStatus), ArrayUtils.toString((Object)rsync.getErrorLines())});
            return null;
        }
        log.info("Downloaded certificate {} to {}", (Object)trustAnchorCertificateURI, (Object)targetFile);
        return targetFile;
    }
}

