/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roas;

import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.roas.ValidatedRoasController;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/roas"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class ValidatedRoasController {
    private static final Logger log = LoggerFactory.getLogger(ValidatedRoasController.class);
    @Autowired
    private ValidatedRpkiObjects validatedRpkiObjects;

    @GetMapping
    public ResponseEntity<ApiResponse<Stream<RoaPrefix>>> list(@RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", defaultValue="", required=false) String searchString, @RequestParam(name="sortBy", defaultValue="prefix") String sortBy, @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection) {
        SearchTerm searchTerm = StringUtils.isNotBlank((String)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        ValidatedRpkiObjects.ValidatedObjects currentlyValidatedRoaPrefixes = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes(searchTerm, sorting, paging);
        Stream<RoaPrefix> roas = currentlyValidatedRoaPrefixes.getObjects().map(prefix -> new RoaPrefix(this, String.valueOf(prefix.getAsn()), prefix.getPrefix().toString(), prefix.getEffectiveLength(), prefix.getTrustAnchor().getName(), (String)prefix.getLocations().first()));
        long totalSize = currentlyValidatedRoaPrefixes.getTotalCount();
        Links links = Paging.links((long)startFrom, (long)pageSize, (long)totalSize, (sf, ps) -> ((ValidatedRoasController)ControllerLinkBuilder.methodOn(ValidatedRoasController.class, (Object[])new Object[0])).list(sf.longValue(), ps.longValue(), searchString, sortBy, sortDirection));
        return ResponseEntity.ok((Object)ApiResponse.builder().links(links).metadata(Metadata.of((long)totalSize)).data(roas).build());
    }
}

