/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.ignorefilters;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.rpki.validator3.api.ApiCommand;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.ignorefilters.AddIgnoreFilter;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilter;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterDto;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterService;
import net.ripe.rpki.validator3.api.roas.ObjectController;
import net.ripe.rpki.validator3.domain.IgnoreFiltersPredicate;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/ignore-filters"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class IgnoreFiltersController {
    private static final Logger log = LoggerFactory.getLogger(IgnoreFiltersController.class);
    @Autowired
    private IgnoreFilterService ignoreFilterService;
    @Autowired
    private ValidatedRpkiObjects validatedRpkiObjects;

    @GetMapping
    public ResponseEntity<ApiResponse<Stream<IgnoreFilterDto>>> list(@RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", defaultValue="", required=false) String searchString, @RequestParam(name="sortBy", defaultValue="prefix") String sortBy, @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection) {
        SearchTerm searchTerm = StringUtils.isNotBlank((String)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        Stream matching = this.ignoreFilterService.find(searchTerm, sorting, paging);
        int totalSize = (int)this.ignoreFilterService.count(searchTerm);
        Links links = Paging.links((long)startFrom, (long)pageSize, (long)totalSize, (sf, ps) -> ((IgnoreFiltersController)ControllerLinkBuilder.methodOn(IgnoreFiltersController.class, (Object[])new Object[0])).list(sf.longValue(), ps.longValue(), searchString, sortBy, sortDirection));
        return ResponseEntity.ok((Object)ApiResponse.builder().links(links).metadata(Metadata.of((long)totalSize)).data(matching.map(arg_0 -> this.toIgnoreFilter(arg_0))).build());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ApiResponse<IgnoreFilterDto>> get(@PathVariable long id) {
        return ResponseEntity.ok((Object)this.ignoreFilterResource(this.ignoreFilterService.get(id)));
    }

    @PostMapping(consumes={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
    public ResponseEntity<ApiResponse<IgnoreFilterDto>> add(@RequestBody @Valid ApiCommand<AddIgnoreFilter> command) throws Exception {
        long id = this.ignoreFilterService.execute((AddIgnoreFilter)command.getData());
        IgnoreFilter ignoreFilter = this.ignoreFilterService.get(id);
        Link selfRel = ControllerLinkBuilder.linkTo((Object)((IgnoreFiltersController)ControllerLinkBuilder.methodOn(IgnoreFiltersController.class, (Object[])new Object[0])).get(id)).withSelfRel();
        return ResponseEntity.created((URI)URI.create(selfRel.getHref())).body((Object)this.ignoreFilterResource(ignoreFilter));
    }

    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable long id) {
        this.ignoreFilterService.remove(id);
        return ResponseEntity.noContent().build();
    }

    private IgnoreFilterDto toIgnoreFilter(IgnoreFilter f) {
        IgnoreFiltersPredicate ignoreFiltersPredicate = new IgnoreFiltersPredicate(Stream.of(f));
        List affectedRoas = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes(null, null, null).getObjects().filter(ignoreFiltersPredicate).map(prefix -> new ObjectController.RoaPrefix(String.valueOf(prefix.getAsn()), prefix.getPrefix().toString(), prefix.getEffectiveLength())).collect(Collectors.toList());
        return new IgnoreFilterDto(f, affectedRoas);
    }

    private ApiResponse<IgnoreFilterDto> ignoreFilterResource(IgnoreFilter ignoreFilter) {
        return ApiResponse.builder().data((Object)new IgnoreFilterDto(ignoreFilter)).build();
    }
}

