/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgpsec;

import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.ripe.rpki.validator3.api.bgpsec.AddBgpSecAssertion;
import net.ripe.rpki.validator3.domain.constraints.ValidAsn;

public class AddBgpSecAssertion {
    @ApiModelProperty(position=1, required=true)
    @ValidAsn
    String asn;
    @ApiModelProperty(position=2, required=true)
    @NotNull
    String ski;
    @ApiModelProperty(position=3, required=true)
    @NotNull
    String publicKey;
    @ApiModelProperty(position=4)
    @Size(max=2000)
    @Size(max=2000) String comment;

    @ConstructorProperties(value={"asn", "ski", "publicKey", "comment"})
    AddBgpSecAssertion(String asn, String ski, String publicKey, String comment) {
        this.asn = asn;
        this.ski = ski;
        this.publicKey = publicKey;
        this.comment = comment;
    }

    public static AddBgpSecAssertionBuilder builder() {
        return new AddBgpSecAssertionBuilder();
    }

    private AddBgpSecAssertion() {
    }

    public String getAsn() {
        return this.asn;
    }

    public String getSki() {
        return this.ski;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getComment() {
        return this.comment;
    }

    public void setAsn(String asn) {
        this.asn = asn;
    }

    public void setSki(String ski) {
        this.ski = ski;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddBgpSecAssertion)) {
            return false;
        }
        AddBgpSecAssertion other = (AddBgpSecAssertion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$asn = this.getAsn();
        String other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
            return false;
        }
        String this$ski = this.getSki();
        String other$ski = other.getSki();
        if (this$ski == null ? other$ski != null : !this$ski.equals(other$ski)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddBgpSecAssertion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
        String $ski = this.getSki();
        result = result * 59 + ($ski == null ? 43 : $ski.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "AddBgpSecAssertion(asn=" + this.getAsn() + ", ski=" + this.getSki() + ", publicKey=" + this.getPublicKey() + ", comment=" + this.getComment() + ")";
    }
}

