/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr;

import fj.data.Either;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import net.ripe.rpki.rtr.adapter.netty.ChunkedStream;
import net.ripe.rpki.rtr.domain.RtrCache;
import net.ripe.rpki.rtr.domain.RtrClient;
import net.ripe.rpki.rtr.domain.RtrClients;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.pdus.CacheResetPdu;
import net.ripe.rpki.rtr.domain.pdus.CacheResponsePdu;
import net.ripe.rpki.rtr.domain.pdus.EndOfDataPdu;
import net.ripe.rpki.rtr.domain.pdus.ErrorCode;
import net.ripe.rpki.rtr.domain.pdus.ErrorPdu;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.NotifyPdu;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;
import net.ripe.rpki.rtr.domain.pdus.ResetQueryPdu;
import net.ripe.rpki.rtr.domain.pdus.RtrProtocolException;
import net.ripe.rpki.rtr.domain.pdus.SerialQueryPdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="prototype")
public class RtrClientHandler
extends SimpleChannelInboundHandler<Pdu>
implements RtrClient {
    private static final Logger log = LoggerFactory.getLogger(RtrClientHandler.class);
    private final RtrCache cache;
    private final RtrClients clients;
    @Value(value="${rtr.client.refresh.interval}")
    private int clientRefreshInterval;
    @Value(value="${rtr.client.retry.interval}")
    private int clientRetryInterval;
    @Value(value="${rtr.client.expire.interval}")
    private int clientExpireInterval;
    private ChannelHandlerContext ctx;
    private Pdu currentRequest = null;
    private Queue<Pdu> pending = new ArrayDeque();
    private short clientSessionId;
    private SerialNumber clientSerialNumber = SerialNumber.zero();
    private SerialNumber latestNotifySerialNumber = SerialNumber.zero();
    private ProtocolVersion clientProtocolVersion = null;
    private Instant clientConnectedAt = Instant.now();
    private Instant lastRequestReceivedAt = null;
    private AbstractTrafficShapingHandler trafficShapingHandler;

    @Autowired
    public RtrClientHandler(RtrCache cache, RtrClients clients) {
        this.cache = Objects.requireNonNull(cache, "cache");
        this.clients = clients;
        this.clientSessionId = cache.getSessionId();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.ctx = ctx;
        this.clients.register((RtrClient)this);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clients.unregister((RtrClient)this);
        super.channelInactive(ctx);
    }

    public synchronized void channelRead0(ChannelHandlerContext ctx, Pdu pdu) {
        this.lastRequestReceivedAt = Instant.now();
        if (this.currentRequest != null) {
            this.pending.add(pdu);
            log.info("currently busy handling request, queuing {}", (Object)pdu);
            return;
        }
        this.currentRequest = pdu;
        ChannelFuture responseComplete = this.handleClientRequest(ctx, pdu);
        if (responseComplete != null) {
            responseComplete.addListener(f -> this.requestHandlingCompleted());
        }
    }

    private synchronized void requestHandlingCompleted() {
        this.currentRequest = (Pdu)this.pending.poll();
        if (this.currentRequest == null) {
            log.info("finished processing all pending requests for {}", (Object)this);
            this.sendNotifyPduIfNeeded(this.cache.getSessionId(), this.cache.getSerialNumber());
        } else {
            ChannelFuture channelFuture = this.handleClientRequest(this.ctx, this.currentRequest);
            if (channelFuture != null) {
                channelFuture.addListener(f -> this.requestHandlingCompleted());
            }
        }
    }

    private ChannelFuture handleClientRequest(ChannelHandlerContext ctx, Pdu pdu) {
        log.info("handling client request {}", (Object)pdu);
        if (this.clientProtocolVersion == null) {
            this.clientProtocolVersion = pdu.getProtocolVersion();
        } else if (this.clientProtocolVersion != pdu.getProtocolVersion()) {
            throw new RtrProtocolException(ErrorPdu.of((ProtocolVersion)this.clientProtocolVersion, (ErrorCode)ErrorCode.UnexpectedProtocolVersion, (byte[])pdu.toByteArray(), (String)String.format("unexpected PDU protocol version %d, negotiated version was %d", pdu.getProtocolVersion().getValue(), this.clientProtocolVersion.getValue())));
        }
        ChannelFuture responseComplete = null;
        if (pdu instanceof SerialQueryPdu) {
            responseComplete = this.handleSerialQuery(ctx, (SerialQueryPdu)pdu);
        } else if (pdu instanceof ResetQueryPdu) {
            responseComplete = this.handleResetQuery(ctx, (ResetQueryPdu)pdu);
        } else if (pdu instanceof ErrorPdu) {
            log.error("error received from client {}, closing connection", (Object)pdu);
            ctx.close();
        } else {
            throw new IllegalStateException("unrecognized PDU " + pdu);
        }
        return responseComplete;
    }

    private ChannelFuture handleSerialQuery(ChannelHandlerContext ctx, SerialQueryPdu serialQueryPdu) {
        Either deltaOrContent = this.cache.getDeltaOrContent(serialQueryPdu.getSerialNumber());
        if (deltaOrContent.right().exists(content -> !content.isReady())) {
            return ctx.writeAndFlush((Object)ErrorPdu.of((ProtocolVersion)this.clientProtocolVersion, (ErrorCode)ErrorCode.NoDataAvailable, (byte[])serialQueryPdu.toByteArray(), (String)""));
        }
        if (deltaOrContent.isLeft()) {
            RtrCache.Delta delta = (RtrCache.Delta)deltaOrContent.left().value();
            if (delta.getSessionId() != serialQueryPdu.getSessionId()) {
                return ctx.writeAndFlush((Object)CacheResetPdu.of((ProtocolVersion)this.clientProtocolVersion));
            }
            this.clientSessionId = delta.getSessionId();
            this.clientSerialNumber = delta.getSerialNumber();
            ctx.write((Object)CacheResponsePdu.of((ProtocolVersion)this.clientProtocolVersion, (short)delta.getSessionId()));
            ctx.write((Object)new ChunkedStream(delta.getAnnouncements().stream().map(dataUnit -> dataUnit.toPdu(this.clientProtocolVersion, Flags.ANNOUNCEMENT))));
            ctx.write((Object)new ChunkedStream(delta.getWithdrawals().stream().map(dataUnit -> dataUnit.toPdu(this.clientProtocolVersion, Flags.WITHDRAWAL))));
            return ctx.writeAndFlush((Object)EndOfDataPdu.of((ProtocolVersion)this.clientProtocolVersion, (short)this.clientSessionId, (SerialNumber)this.clientSerialNumber, (int)this.clientRefreshInterval, (int)this.clientRetryInterval, (int)this.clientExpireInterval));
        }
        RtrCache.Content content2 = (RtrCache.Content)deltaOrContent.right().value();
        this.clientSessionId = content2.getSessionId();
        this.clientSerialNumber = content2.getSerialNumber();
        return ctx.writeAndFlush((Object)CacheResetPdu.of((ProtocolVersion)this.clientProtocolVersion));
    }

    private ChannelFuture handleResetQuery(ChannelHandlerContext ctx, ResetQueryPdu resetQueryPdu) {
        RtrCache.Content content = this.cache.getCurrentContent();
        if (!content.isReady()) {
            return ctx.writeAndFlush((Object)ErrorPdu.of((ProtocolVersion)this.clientProtocolVersion, (ErrorCode)ErrorCode.NoDataAvailable, (byte[])resetQueryPdu.toByteArray(), (String)""));
        }
        this.clientSessionId = content.getSessionId();
        this.clientSerialNumber = content.getSerialNumber();
        ctx.write((Object)CacheResponsePdu.of((ProtocolVersion)this.clientProtocolVersion, (short)content.getSessionId()));
        ctx.write((Object)new ChunkedStream(content.getAnnouncements().stream().map(dataUnit -> dataUnit.toPdu(this.clientProtocolVersion, Flags.ANNOUNCEMENT))));
        return ctx.writeAndFlush((Object)EndOfDataPdu.of((ProtocolVersion)this.clientProtocolVersion, (short)this.clientSessionId, (SerialNumber)this.clientSerialNumber, (int)this.clientRefreshInterval, (int)this.clientRetryInterval, (int)this.clientExpireInterval));
    }

    private static Optional<RtrProtocolException> getRtrError(Throwable cause) {
        for (Throwable t = cause; t != null && t != t.getCause(); t = t.getCause()) {
            if (!(t instanceof RtrProtocolException)) continue;
            return Optional.of((RtrProtocolException)t);
        }
        return Optional.empty();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Optional rtrError = RtrClientHandler.getRtrError((Throwable)cause);
        if (rtrError.filter(x -> !x.isSendToClient()).isPresent()) {
            log.warn("do not send error in response to client error PDU", (Throwable)rtrError.get());
            ctx.close();
            return;
        }
        ErrorPdu errorPdu = rtrError.map(RtrProtocolException::getErrorPdu).orElseGet(() -> ErrorPdu.of((ProtocolVersion)(this.clientProtocolVersion == null ? ProtocolVersion.V1 : this.clientProtocolVersion), (ErrorCode)ErrorCode.PduInternalError, (byte[])new byte[0], (String)""));
        ctx.writeAndFlush((Object)errorPdu);
        if (errorPdu.getErrorCode().isFatal()) {
            ctx.close();
        }
    }

    public SerialNumber getClientSerialNumber() {
        return this.clientSerialNumber;
    }

    private Instant getLastActivityAt() {
        return this.lastRequestReceivedAt != null ? this.lastRequestReceivedAt : this.clientConnectedAt;
    }

    public synchronized void cacheUpdated(short sessionId, SerialNumber updatedSerialNumber) {
        this.sendNotifyPduIfNeeded(sessionId, updatedSerialNumber);
    }

    public boolean disconnectIfInactive(Instant now) {
        if (this.getLastActivityAt().isBefore(now.minusSeconds(this.clientExpireInterval))) {
            this.ctx.close();
            return true;
        }
        return false;
    }

    public synchronized RtrClient.State getState() {
        return new RtrClient.State(this.ctx.channel().localAddress().toString(), this.ctx.channel().remoteAddress().toString(), this.clientConnectedAt, this.getLastActivityAt(), (int)this.clientProtocolVersion.getValue(), this.clientSessionId, this.clientSerialNumber.getValue(), this.trafficShapingHandler.trafficCounter().cumulativeReadBytes(), this.trafficShapingHandler.trafficCounter().cumulativeWrittenBytes());
    }

    private void sendNotifyPduIfNeeded(short sessionId, SerialNumber updatedSerialNumber) {
        if (this.currentRequest == null && this.lastRequestReceivedAt != null && this.clientProtocolVersion != null && updatedSerialNumber.isAfter(this.clientSerialNumber) && updatedSerialNumber.isAfter(this.latestNotifySerialNumber)) {
            log.info("Sending notify PDU to client for serial number {}", (Object)updatedSerialNumber.getValue());
            this.latestNotifySerialNumber = updatedSerialNumber;
            this.ctx.writeAndFlush((Object)NotifyPdu.of((ProtocolVersion)this.clientProtocolVersion, (short)sessionId, (SerialNumber)updatedSerialNumber));
        }
    }

    public String toString() {
        return "RtrClientHandler(clientRefreshInterval=" + this.clientRefreshInterval + ", clientRetryInterval=" + this.clientRetryInterval + ", clientExpireInterval=" + this.clientExpireInterval + ", ctx=" + this.ctx + ", currentRequest=" + this.currentRequest + ", pending=" + this.pending + ", clientSessionId=" + this.clientSessionId + ", clientSerialNumber=" + this.getClientSerialNumber() + ", latestNotifySerialNumber=" + this.latestNotifySerialNumber + ", clientProtocolVersion=" + this.clientProtocolVersion + ", clientConnectedAt=" + this.clientConnectedAt + ", lastRequestReceivedAt=" + this.lastRequestReceivedAt + ", trafficShapingHandler=" + this.trafficShapingHandler + ")";
    }

    void setClientRefreshInterval(int clientRefreshInterval) {
        this.clientRefreshInterval = clientRefreshInterval;
    }

    void setClientRetryInterval(int clientRetryInterval) {
        this.clientRetryInterval = clientRetryInterval;
    }

    void setClientExpireInterval(int clientExpireInterval) {
        this.clientExpireInterval = clientExpireInterval;
    }

    public void setTrafficShapingHandler(AbstractTrafficShapingHandler trafficShapingHandler) {
        this.trafficShapingHandler = trafficShapingHandler;
    }
}

