/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.Links;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class ApiConfig
implements WebMvcConfigurer {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer includeNonNullOnly() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizeLinksRendering() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializerByType(Links.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
            jacksonObjectMapperBuilder.deserializerByType(Links.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        };
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.valueOf((String)"text/json")));
        converters.add((HttpMessageConverter<?>)converter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false).defaultContentType(new MediaType[]{MediaType.valueOf((String)"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8")});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/metrics").setViewName("forward:/actuator/prometheus");
    }
}

