/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import fj.data.Either;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.rtr.domain.RtrCache;
import net.ripe.rpki.rtr.domain.RtrDataUnit;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.VersionedSet;
import net.ripe.rpki.rtr.util.Locks;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class RtrCache {
    private static final Logger log = LoggerFactory.getLogger(RtrCache.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private final SerialNumber initialVersion;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile short sessionId;
    private volatile boolean ready;
    private VersionedSet<RtrDataUnit> data;

    @Autowired
    public RtrCache(MeterRegistry registry) {
        this(registry, SerialNumber.zero());
    }

    public RtrCache(MeterRegistry registry, SerialNumber initialVersion) {
        this.initialVersion = initialVersion;
        this.reset();
        Gauge.builder((String)"validated.objects.count", () -> this.data.size()).description("Number of validated objects").register(registry);
        Gauge.builder((String)"validated.objects.ready", () -> this.ready ? 1 : 0).description("Status of the cache").register(registry);
        Gauge.builder((String)"validated.objects.session.id", () -> this.sessionId).description("Session id of the cache").register(registry);
        Gauge.builder((String)"validated.objects.serial", () -> this.getSerialNumber().getValue()).description("Serial of the cache").register(registry);
    }

    public void reset() {
        Locks.locked((Lock)this.lock.writeLock(), () -> {
            this.ready = false;
            this.generateNewSessionId();
            this.data = new VersionedSet(this.initialVersion);
        });
    }

    private void generateNewSessionId() {
        short newSessionId;
        while (this.sessionId == (newSessionId = (short)RANDOM.nextInt())) {
        }
        this.sessionId = newSessionId;
    }

    public Optional<SerialNumber> update(Collection<RtrDataUnit> updatedPdus) {
        return this.update(updatedPdus.stream());
    }

    public Optional<SerialNumber> update(Stream<RtrDataUnit> updatedPdus) {
        return (Optional)Locks.locked((Lock)this.lock.writeLock(), () -> {
            this.ready = true;
            if (this.data.updateValues(updatedPdus)) {
                log.info("{} validated ROAs updated to serial number {} (delta with {} announcements, {} withdrawals)", new Object[]{this.data.size(), this.data.getCurrentVersion().getValue(), this.data.getDelta(this.data.getCurrentVersion().previous()).map(x -> x.getAdditions().size()).orElse(0), this.data.getDelta(this.data.getCurrentVersion().previous()).map(x -> x.getRemovals().size()).orElse(0)});
                return Optional.of(this.data.getCurrentVersion());
            }
            log.info("no updates to cached data");
            return Optional.empty();
        });
    }

    public Content getCurrentContent() {
        return (Content)Locks.locked((Lock)this.lock.readLock(), () -> this.getCurrentContentNoLock());
    }

    private Content getCurrentContentNoLock() {
        return Content.of((short)this.sessionId, (SerialNumber)this.getSerialNumber(), (boolean)this.ready, (SortedSet)this.data.getValues());
    }

    public SerialNumber getSerialNumber() {
        return (SerialNumber)Locks.locked((Lock)this.lock.readLock(), () -> this.data.getCurrentVersion());
    }

    Optional<Delta> getDeltaFrom(SerialNumber serialNumber) {
        return (Optional)Locks.locked((Lock)this.lock.readLock(), () -> {
            if (!this.ready || serialNumber.isAfter(this.getSerialNumber())) {
                return Optional.empty();
            }
            if (serialNumber.equals((Object)this.getSerialNumber())) {
                return Optional.of(Delta.of((short)this.sessionId, (SerialNumber)serialNumber, Collections.emptySortedSet(), Collections.emptySortedSet()));
            }
            Optional delta = this.data.getDelta(serialNumber);
            return delta.map(d -> Delta.of((short)this.sessionId, (SerialNumber)this.getSerialNumber(), (SortedSet)d.getAdditions(), (SortedSet)d.getRemovals()));
        });
    }

    public Either<Delta, Content> getDeltaOrContent(SerialNumber serialNumber) {
        return (Either)Locks.locked((Lock)this.lock.readLock(), () -> this.getDeltaFrom(serialNumber).map(Either::left).orElseGet(() -> Either.right((Object)this.getCurrentContentNoLock())));
    }

    public Set<SerialNumber> forgetDeltasBefore(SerialNumber serialNumber) {
        return (Set)Locks.locked((Lock)this.lock.writeLock(), () -> this.data.forgetDeltasBefore(serialNumber));
    }

    public State getState() {
        Triple t = (Triple)Locks.locked((Lock)this.lock.readLock(), () -> Triple.of((Object)this.getCurrentContentNoLock(), (Object)this.data, (Object)this.sessionId));
        Content content = (Content)t.getLeft();
        VersionedSet data = (VersionedSet)t.getMiddle();
        Short sessionId = (Short)t.getRight();
        SortedMap deltas = (SortedMap)data.getDeltas().entrySet().stream().map(entry -> Delta.of((short)sessionId, (SerialNumber)((SerialNumber)entry.getKey()), (SortedSet)((VersionedSet.Delta)entry.getValue()).getAdditions(), (SortedSet)((VersionedSet.Delta)entry.getValue()).getRemovals())).collect(this.toSortedMap());
        return new State(content, deltas);
    }

    private Collector<Delta, ?, SortedMap<SerialNumber, Delta>> toSortedMap() {
        return Collectors.toMap(delta -> delta.getSerialNumber(), delta -> delta, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new);
    }

    public short getSessionId() {
        return this.sessionId;
    }
}

