/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.adapter.validator;

import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.rtr.adapter.validator.RefreshCacheController;
import net.ripe.rpki.rtr.domain.RtrCache;
import net.ripe.rpki.rtr.domain.RtrClients;
import net.ripe.rpki.rtr.domain.RtrDataUnit;
import net.ripe.rpki.rtr.domain.RtrPrefix;
import net.ripe.rpki.rtr.domain.RtrRouterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RefreshCacheController {
    private static final Logger log = LoggerFactory.getLogger(RefreshCacheController.class);
    private AtomicBoolean lastRefreshSucceeded = new AtomicBoolean(false);
    private final RestTemplate restTemplate;
    @Value(value="${rpki.validator.validated.objects.uri}")
    private URI validatedObjectsUri;
    @Autowired
    private RtrCache cache;
    @Autowired
    private RtrClients clients;

    public RefreshCacheController(RestTemplateBuilder restTemplateBuilder) {
        log.info("RefreshCacheController loaded");
        this.restTemplate = restTemplateBuilder.build();
    }

    public void refreshObjectCache() {
        boolean previousRefreshSucceeded = this.lastRefreshSucceeded.getAndSet(false);
        log.info("fetching validated roa prefixes from {}", (Object)this.validatedObjectsUri);
        ValidatedObjectsResponse response = (ValidatedObjectsResponse)this.restTemplate.getForObject(this.validatedObjectsUri, ValidatedObjectsResponse.class);
        ValidatedObjects validatedObjects = response.getData();
        if (!ValidatedObjects.access$000((ValidatedObjects)validatedObjects)) {
            log.info("validator {} not ready yet, will retry later", (Object)this.validatedObjectsUri);
            return;
        }
        if (!previousRefreshSucceeded) {
            log.info("validator {} is ready.", (Object)this.validatedObjectsUri);
        }
        List validatedPrefixes = validatedObjects.getRoas();
        log.info("fetched {} validated roa prefixes from {}", (Object)validatedPrefixes.size(), (Object)this.validatedObjectsUri);
        Stream<RtrPrefix> roaPrefixes = validatedPrefixes.stream().map(prefix -> RtrDataUnit.prefix((Asn)Asn.parse((String)prefix.getAsn()), (IpRange)IpRange.parse((String)prefix.getPrefix()), (Integer)prefix.getMaxLength()));
        Base64.Decoder decoder = Base64.getDecoder();
        Stream routerCertificates = validatedObjects.getRouterCertificates().stream().flatMap(rc -> RouterCertificate.access$100((RouterCertificate)rc).stream().map(a -> {
            int asn = Math.toIntExact(Asn.parse((String)a).longValue());
            return RtrRouterKey.of((byte[])decoder.decode(RouterCertificate.access$200((RouterCertificate)rc)), (byte[])decoder.decode(RouterCertificate.access$300((RouterCertificate)rc)), (int)asn);
        }));
        this.cache.update(Stream.concat(roaPrefixes, routerCertificates)).ifPresent(updatedSerialNumber -> this.clients.cacheUpdated(this.cache.getSessionId(), updatedSerialNumber));
        this.lastRefreshSucceeded.set(true);
    }
}

