/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;
import net.ripe.rpki.rtr.domain.pdus.RouterKeyPdu;

public final class RouterKeyPdu
implements Pdu {
    public static final int PDU_TYPE = 9;
    private final ProtocolVersion protocolVersion;
    private final Flags flags;
    private final byte[] subjectKeyIdentifier;
    private final byte[] subjectPublicKeyInfo;
    private final int asn;

    public int length() {
        return 8 + this.subjectKeyIdentifier.length + 4 + this.subjectPublicKeyInfo.length;
    }

    public void write(ByteBuf out) {
        switch (1.$SwitchMap$net$ripe$rpki$rtr$domain$pdus$ProtocolVersion[this.protocolVersion.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                out.writeByte((int)this.protocolVersion.getValue()).writeByte(9).writeByte(this.flags.getFlags()).writeByte(0).writeInt(this.length()).writeBytes(this.subjectKeyIdentifier).writeInt(this.asn).writeBytes(this.subjectPublicKeyInfo);
            }
        }
    }

    @ConstructorProperties(value={"protocolVersion", "flags", "subjectKeyIdentifier", "subjectPublicKeyInfo", "asn"})
    private RouterKeyPdu(ProtocolVersion protocolVersion, Flags flags, byte[] subjectKeyIdentifier, byte[] subjectPublicKeyInfo, int asn) {
        this.protocolVersion = protocolVersion;
        this.flags = flags;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.asn = asn;
    }

    public static RouterKeyPdu of(ProtocolVersion protocolVersion, Flags flags, byte[] subjectKeyIdentifier, byte[] subjectPublicKeyInfo, int asn) {
        return new RouterKeyPdu(protocolVersion, flags, subjectKeyIdentifier, subjectPublicKeyInfo, asn);
    }

    private RouterKeyPdu() {
        this.protocolVersion = null;
        this.flags = null;
        this.subjectKeyIdentifier = null;
        this.subjectPublicKeyInfo = null;
        this.asn = 0;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public byte[] getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public int getAsn() {
        return this.asn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouterKeyPdu)) {
            return false;
        }
        RouterKeyPdu other = (RouterKeyPdu)o;
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
            return false;
        }
        if (!Arrays.equals(this.getSubjectKeyIdentifier(), other.getSubjectKeyIdentifier())) {
            return false;
        }
        if (!Arrays.equals(this.getSubjectPublicKeyInfo(), other.getSubjectPublicKeyInfo())) {
            return false;
        }
        return this.getAsn() == other.getAsn();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSubjectKeyIdentifier());
        result = result * 59 + Arrays.hashCode(this.getSubjectPublicKeyInfo());
        result = result * 59 + this.getAsn();
        return result;
    }

    public String toString() {
        return "RouterKeyPdu(protocolVersion=" + this.getProtocolVersion() + ", flags=" + this.getFlags() + ", subjectKeyIdentifier=" + Arrays.toString(this.getSubjectKeyIdentifier()) + ", subjectPublicKeyInfo=" + Arrays.toString(this.getSubjectPublicKeyInfo()) + ", asn=" + this.getAsn() + ")";
    }
}

