/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public final class NotifyPdu
implements Pdu {
    public static final int PDU_TYPE = 0;
    public static final int PDU_LENGTH = 12;
    private final ProtocolVersion protocolVersion;
    private final short sessionId;
    private final SerialNumber serialNumber;

    public int length() {
        return 12;
    }

    public void write(ByteBuf out) {
        out.writeByte((int)this.protocolVersion.getValue()).writeByte(0).writeShort((int)this.sessionId).writeInt(this.length()).writeInt(this.serialNumber.getValue());
    }

    @ConstructorProperties(value={"protocolVersion", "sessionId", "serialNumber"})
    private NotifyPdu(ProtocolVersion protocolVersion, short sessionId, SerialNumber serialNumber) {
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
        this.serialNumber = serialNumber;
    }

    public static NotifyPdu of(ProtocolVersion protocolVersion, short sessionId, SerialNumber serialNumber) {
        return new NotifyPdu(protocolVersion, sessionId, serialNumber);
    }

    private NotifyPdu() {
        this.protocolVersion = null;
        this.sessionId = 0;
        this.serialNumber = null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public SerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyPdu)) {
            return false;
        }
        NotifyPdu other = (NotifyPdu)o;
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        SerialNumber this$serialNumber = this.getSerialNumber();
        SerialNumber other$serialNumber = other.getSerialNumber();
        return !(this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        result = result * 59 + this.getSessionId();
        SerialNumber $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        return result;
    }

    public String toString() {
        return "NotifyPdu(protocolVersion=" + this.getProtocolVersion() + ", sessionId=" + this.getSessionId() + ", serialNumber=" + this.getSerialNumber() + ")";
    }
}

