/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.pdus.EndOfDataPdu;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public final class EndOfDataPdu
implements Pdu {
    public static final int PDU_TYPE = 7;
    public static final int PDU_LENGTH_V0 = 12;
    public static final int PDU_LENGTH_V1 = 24;
    private final ProtocolVersion protocolVersion;
    private final short sessionId;
    private final SerialNumber serialNumber;
    private final int refreshInterval;
    private final int retryInterval;
    private final int expireInterval;

    public int length() {
        switch (1.$SwitchMap$net$ripe$rpki$rtr$domain$pdus$ProtocolVersion[this.protocolVersion.ordinal()]) {
            case 1: {
                return 12;
            }
            case 2: {
                return 24;
            }
        }
        throw new IllegalStateException("bad protocol version " + this.protocolVersion);
    }

    public void write(ByteBuf out) {
        out.writeByte((int)this.protocolVersion.getValue()).writeByte(7).writeShort((int)this.sessionId).writeInt(this.length()).writeInt(this.serialNumber.getValue());
        switch (1.$SwitchMap$net$ripe$rpki$rtr$domain$pdus$ProtocolVersion[this.protocolVersion.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                out.writeInt(this.refreshInterval).writeInt(this.retryInterval).writeInt(this.expireInterval);
                return;
            }
        }
        throw new IllegalStateException("bad protocol version " + this.protocolVersion);
    }

    @ConstructorProperties(value={"protocolVersion", "sessionId", "serialNumber", "refreshInterval", "retryInterval", "expireInterval"})
    private EndOfDataPdu(ProtocolVersion protocolVersion, short sessionId, SerialNumber serialNumber, int refreshInterval, int retryInterval, int expireInterval) {
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
        this.serialNumber = serialNumber;
        this.refreshInterval = refreshInterval;
        this.retryInterval = retryInterval;
        this.expireInterval = expireInterval;
    }

    public static EndOfDataPdu of(ProtocolVersion protocolVersion, short sessionId, SerialNumber serialNumber, int refreshInterval, int retryInterval, int expireInterval) {
        return new EndOfDataPdu(protocolVersion, sessionId, serialNumber, refreshInterval, retryInterval, expireInterval);
    }

    private EndOfDataPdu() {
        this.protocolVersion = null;
        this.sessionId = 0;
        this.serialNumber = null;
        this.refreshInterval = 0;
        this.retryInterval = 0;
        this.expireInterval = 0;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public SerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getExpireInterval() {
        return this.expireInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndOfDataPdu)) {
            return false;
        }
        EndOfDataPdu other = (EndOfDataPdu)o;
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        SerialNumber this$serialNumber = this.getSerialNumber();
        SerialNumber other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        if (this.getRefreshInterval() != other.getRefreshInterval()) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        return this.getExpireInterval() == other.getExpireInterval();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        result = result * 59 + this.getSessionId();
        SerialNumber $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        result = result * 59 + this.getRefreshInterval();
        result = result * 59 + this.getRetryInterval();
        result = result * 59 + this.getExpireInterval();
        return result;
    }

    public String toString() {
        return "EndOfDataPdu(protocolVersion=" + this.getProtocolVersion() + ", sessionId=" + this.getSessionId() + ", serialNumber=" + this.getSerialNumber() + ", refreshInterval=" + this.getRefreshInterval() + ", retryInterval=" + this.getRetryInterval() + ", expireInterval=" + this.getExpireInterval() + ")";
    }
}

