/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.VersionedSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionedSet<T extends Comparable<T>> {
    private final Delta<T> EMPTY_DELTA = new Delta(Collections.emptySortedSet(), Collections.emptySortedSet(), null);
    private SerialNumber currentVersion;
    private SortedSet<T> values = Collections.emptySortedSet();
    private SortedMap<SerialNumber, Delta<T>> deltas = Collections.emptySortedMap();

    public VersionedSet() {
        this(SerialNumber.zero());
    }

    public VersionedSet(SerialNumber initialVersion) {
        this.currentVersion = initialVersion;
    }

    public boolean updateValues(Collection<T> newValues) {
        return this.updateValues(newValues.stream());
    }

    public boolean updateValues(Stream<T> newValues) {
        SortedSet updatedValues = Collections.unmodifiableSortedSet(VersionedSet.newSortedSet(newValues));
        if (this.values.equals(updatedValues)) {
            return false;
        }
        Delta delta = Delta.calculate((Set)this.values, updatedValues);
        this.deltas = this.updateDeltas(delta);
        this.currentVersion = this.currentVersion.next();
        this.values = updatedValues;
        return true;
    }

    public Set<SerialNumber> forgetDeltasBefore(SerialNumber version) {
        Set<SerialNumber> olderDeltas = this.deltas.keySet().stream().filter(key -> key.compareTo(version) < 0).collect(Collectors.toSet());
        if (!olderDeltas.isEmpty()) {
            this.deltas = Collections.unmodifiableSortedMap(new TreeMap(Maps.filterEntries((SortedMap)this.deltas, entry -> !olderDeltas.contains(entry.getKey()))));
        }
        return olderDeltas;
    }

    public Optional<Delta<T>> getDelta(SerialNumber version) {
        if (version.isAfter(this.currentVersion)) {
            throw new IllegalArgumentException(String.format("requested version %d must not be greater than current version %d", version, this.currentVersion));
        }
        if (version.equals((Object)this.currentVersion)) {
            return Optional.of(this.EMPTY_DELTA);
        }
        return Optional.ofNullable(this.deltas.get(version));
    }

    public int size() {
        return this.values.size();
    }

    private SortedMap<SerialNumber, Delta<T>> updateDeltas(Delta<T> delta) {
        TreeMap<SerialNumber, Object> updatedDeltas = new TreeMap<SerialNumber, Object>(this.deltas);
        updatedDeltas.replaceAll((key, value) -> value.append(delta));
        updatedDeltas.put(this.currentVersion, delta);
        return Collections.unmodifiableSortedMap(updatedDeltas);
    }

    private static <T> SortedSet<T> newSortedSet(Collection<? extends T> values) {
        return new TreeSet<T>(values);
    }

    private static <T> SortedSet<T> newSortedSet(Stream<? extends T> values) {
        return values.collect(Collectors.toCollection(TreeSet::new));
    }

    public SerialNumber getCurrentVersion() {
        return this.currentVersion;
    }

    public SortedSet<T> getValues() {
        return this.values;
    }

    public SortedMap<SerialNumber, Delta<T>> getDeltas() {
        return this.deltas;
    }

    static /* synthetic */ SortedSet access$100(Collection x0) {
        return VersionedSet.newSortedSet((Collection)x0);
    }
}

