/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.RtrDataUnit;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.IPv4PrefixPdu;
import net.ripe.rpki.rtr.domain.pdus.IPv6PrefixPdu;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;
import org.bouncycastle.util.Arrays;

public final class RtrPrefix
implements RtrDataUnit {
    private final byte prefixLength;
    private final byte maxLength;
    private final byte[] prefix;
    private final int asn;

    public Pdu toPdu(ProtocolVersion protocolVersion, Flags flags) {
        if (this.prefix.length == 4) {
            return IPv4PrefixPdu.of((ProtocolVersion)protocolVersion, (Flags)flags, (RtrPrefix)this);
        }
        if (this.prefix.length == 16) {
            return IPv6PrefixPdu.of((ProtocolVersion)protocolVersion, (Flags)flags, (RtrPrefix)this);
        }
        throw new IllegalStateException(String.format("invalid RTR prefix length, expected 4 or 16, was %d", this.prefix.length));
    }

    public int compareToSameType(RtrDataUnit o) {
        RtrPrefix that = (RtrPrefix)o;
        int rc = Integer.compare(this.prefix.length, that.prefix.length);
        if (rc != 0) {
            return rc;
        }
        rc = Arrays.compareUnsigned((byte[])this.prefix, (byte[])that.prefix);
        if (rc != 0) {
            return rc;
        }
        rc = Integer.compareUnsigned(this.prefixLength, that.prefixLength);
        if (rc != 0) {
            return rc;
        }
        rc = Integer.compareUnsigned(this.maxLength, that.maxLength);
        if (rc != 0) {
            return rc;
        }
        return Integer.compareUnsigned(this.asn, that.asn);
    }

    @ConstructorProperties(value={"prefixLength", "maxLength", "prefix", "asn"})
    private RtrPrefix(byte prefixLength, byte maxLength, byte[] prefix, int asn) {
        this.prefixLength = prefixLength;
        this.maxLength = maxLength;
        this.prefix = prefix;
        this.asn = asn;
    }

    public static RtrPrefix of(byte prefixLength, byte maxLength, byte[] prefix, int asn) {
        return new RtrPrefix(prefixLength, maxLength, prefix, asn);
    }

    private RtrPrefix() {
        this.prefixLength = 0;
        this.maxLength = 0;
        this.prefix = null;
        this.asn = 0;
    }

    public byte getPrefixLength() {
        return this.prefixLength;
    }

    public byte getMaxLength() {
        return this.maxLength;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    public int getAsn() {
        return this.asn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtrPrefix)) {
            return false;
        }
        RtrPrefix other = (RtrPrefix)o;
        if (this.getPrefixLength() != other.getPrefixLength()) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (!java.util.Arrays.equals(this.getPrefix(), other.getPrefix())) {
            return false;
        }
        return this.getAsn() == other.getAsn();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPrefixLength();
        result = result * 59 + this.getMaxLength();
        result = result * 59 + java.util.Arrays.hashCode(this.getPrefix());
        result = result * 59 + this.getAsn();
        return result;
    }

    public String toString() {
        return "RtrPrefix(prefixLength=" + this.getPrefixLength() + ", maxLength=" + this.getMaxLength() + ", prefix=" + java.util.Arrays.toString(this.getPrefix()) + ", asn=" + this.getAsn() + ")";
    }
}

