/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.RtrPrefix;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public final class IPv4PrefixPdu
implements Pdu {
    public static final int PDU_TYPE = 4;
    public static final int PDU_LENGTH = 20;
    private final ProtocolVersion protocolVersion;
    private final Flags flags;
    private final RtrPrefix prefix;

    public void write(ByteBuf out) {
        out.writeByte((int)this.protocolVersion.getValue()).writeByte(4).writeShort(0).writeInt(this.length()).writeByte(this.flags.getFlags()).writeByte((int)this.prefix.getPrefixLength()).writeByte((int)this.prefix.getMaxLength()).writeByte(0).writeBytes(this.prefix.getPrefix()).writeInt(this.prefix.getAsn());
    }

    public int length() {
        return 20;
    }

    @ConstructorProperties(value={"protocolVersion", "flags", "prefix"})
    private IPv4PrefixPdu(ProtocolVersion protocolVersion, Flags flags, RtrPrefix prefix) {
        this.protocolVersion = protocolVersion;
        this.flags = flags;
        this.prefix = prefix;
    }

    public static IPv4PrefixPdu of(ProtocolVersion protocolVersion, Flags flags, RtrPrefix prefix) {
        return new IPv4PrefixPdu(protocolVersion, flags, prefix);
    }

    private IPv4PrefixPdu() {
        this.protocolVersion = null;
        this.flags = null;
        this.prefix = null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public RtrPrefix getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPv4PrefixPdu)) {
            return false;
        }
        IPv4PrefixPdu other = (IPv4PrefixPdu)o;
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
            return false;
        }
        RtrPrefix this$prefix = this.getPrefix();
        RtrPrefix other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        RtrPrefix $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }

    public String toString() {
        return "IPv4PrefixPdu(protocolVersion=" + this.getProtocolVersion() + ", flags=" + this.getFlags() + ", prefix=" + this.getPrefix() + ")";
    }
}

