/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.adapter.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.ripe.rpki.rtr.adapter.netty.PduCodec;
import net.ripe.rpki.rtr.domain.RtrPrefix;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.domain.pdus.CacheResetPdu;
import net.ripe.rpki.rtr.domain.pdus.CacheResponsePdu;
import net.ripe.rpki.rtr.domain.pdus.EndOfDataPdu;
import net.ripe.rpki.rtr.domain.pdus.ErrorCode;
import net.ripe.rpki.rtr.domain.pdus.ErrorPdu;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.IPv4PrefixPdu;
import net.ripe.rpki.rtr.domain.pdus.NotifyPdu;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;
import net.ripe.rpki.rtr.domain.pdus.ResetQueryPdu;
import net.ripe.rpki.rtr.domain.pdus.RtrProtocolException;
import net.ripe.rpki.rtr.domain.pdus.SerialQueryPdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PduCodec
extends ByteToMessageCodec<Pdu> {
    private static final Logger log = LoggerFactory.getLogger(PduCodec.class);

    protected void encode(ChannelHandlerContext ctx, Pdu msg, ByteBuf out) throws Exception {
        log.info("writing {}", (Object)msg);
        msg.write(out);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        PduCodec.parsePdu((ByteBuf)in).ifPresent(out::add);
    }

    public static Optional<Pdu> parsePdu(ByteBuf in) {
        if (in.readableBytes() < 8) {
            return Optional.empty();
        }
        in.markReaderIndex();
        byte protocolVersionValue = in.readByte();
        ProtocolVersion protocolVersion = ProtocolVersion.of((byte)protocolVersionValue);
        BiFunction<ErrorCode, String, ErrorPdu> generateError = (code, text) -> {
            in.resetReaderIndex();
            byte[] content = new byte[in.readableBytes()];
            in.readBytes(content);
            return ErrorPdu.of((ProtocolVersion)(protocolVersion == null ? ProtocolVersion.V1 : protocolVersion), (ErrorCode)code, (byte[])content, (String)text);
        };
        if (protocolVersion == null) {
            throw new RtrProtocolException(generateError.apply(ErrorCode.UnsupportedProtocolVersion, String.format("protocol version must be 0 or 1, was %d", Byte.toUnsignedInt(protocolVersionValue))));
        }
        short pduType = in.readUnsignedByte();
        switch (pduType) {
            case 0: {
                short sessionId = in.readShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)12, (String)"Serial Notify", generateError)) {
                    return Optional.empty();
                }
                int serialNumber = in.readInt();
                return Optional.of(NotifyPdu.of((ProtocolVersion)protocolVersion, (short)sessionId, (SerialNumber)SerialNumber.of((int)serialNumber)));
            }
            case 1: {
                short sessionId = in.readShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)12, (String)"Serial Query", generateError)) {
                    return Optional.empty();
                }
                int serialNumber = in.readInt();
                return Optional.of(SerialQueryPdu.of((ProtocolVersion)protocolVersion, (short)sessionId, (SerialNumber)SerialNumber.of((int)serialNumber)));
            }
            case 2: {
                in.readUnsignedShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)8, (String)"Reset Query", generateError)) {
                    return Optional.empty();
                }
                return Optional.of(ResetQueryPdu.of((ProtocolVersion)protocolVersion));
            }
            case 3: {
                short sessionId = in.readShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)8, (String)"Cache Response", generateError)) {
                    return Optional.empty();
                }
                return Optional.of(CacheResponsePdu.of((ProtocolVersion)protocolVersion, (short)sessionId));
            }
            case 4: {
                in.readShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)20, (String)"IPv4 Prefix", generateError)) {
                    return Optional.empty();
                }
                Flags flags = (in.readByte() & 1) == 0 ? Flags.WITHDRAWAL : Flags.ANNOUNCEMENT;
                byte prefixLength = in.readByte();
                byte maxLength = in.readByte();
                in.readByte();
                byte[] prefix = ByteBufUtil.getBytes((ByteBuf)in.readBytes(4));
                int asn = in.readInt();
                return Optional.of(IPv4PrefixPdu.of((ProtocolVersion)protocolVersion, (Flags)flags, (RtrPrefix)RtrPrefix.of((byte)prefixLength, (byte)maxLength, (byte[])prefix, (int)asn)));
            }
            case 6: {
                in.readShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)32, (String)"IPv6 Prefix", generateError)) {
                    return Optional.empty();
                }
                Flags flags = (in.readByte() & 1) == 0 ? Flags.WITHDRAWAL : Flags.ANNOUNCEMENT;
                byte prefixLength = in.readByte();
                byte maxLength = in.readByte();
                in.readByte();
                byte[] prefix = ByteBufUtil.getBytes((ByteBuf)in.readBytes(16));
                int asn = in.readInt();
                return Optional.of(IPv4PrefixPdu.of((ProtocolVersion)protocolVersion, (Flags)flags, (RtrPrefix)RtrPrefix.of((byte)prefixLength, (byte)maxLength, (byte[])prefix, (int)asn)));
            }
            case 7: {
                short sessionId = in.readShort();
                switch (1.$SwitchMap$net$ripe$rpki$rtr$domain$pdus$ProtocolVersion[protocolVersion.ordinal()]) {
                    case 1: {
                        if (!PduCodec.checkLength((ByteBuf)in, (int)12, (String)"End of Data", generateError)) {
                            return Optional.empty();
                        }
                        int serialNumber = in.readInt();
                        return Optional.of(EndOfDataPdu.of((ProtocolVersion)ProtocolVersion.V0, (short)sessionId, (SerialNumber)SerialNumber.of((int)serialNumber), (int)3600, (int)600, (int)7200));
                    }
                    case 2: {
                        if (!PduCodec.checkLength((ByteBuf)in, (int)24, (String)"End of Data", generateError)) {
                            return Optional.empty();
                        }
                        int serialNumber = in.readInt();
                        int refreshInterval = in.readInt();
                        int retryInterval = in.readInt();
                        int expireInterval = in.readInt();
                        return Optional.of(EndOfDataPdu.of((ProtocolVersion)ProtocolVersion.V1, (short)sessionId, (SerialNumber)SerialNumber.of((int)serialNumber), (int)refreshInterval, (int)retryInterval, (int)expireInterval));
                    }
                }
                throw new IllegalStateException("bad protocol version " + protocolVersion);
            }
            case 8: {
                in.readUnsignedShort();
                if (!PduCodec.checkLength((ByteBuf)in, (int)8, (String)"Cache Reset", generateError)) {
                    return Optional.empty();
                }
                return Optional.of(CacheResetPdu.of((ProtocolVersion)protocolVersion));
            }
            case 10: {
                int errorCode = in.readUnsignedShort();
                long length = in.readUnsignedInt();
                if (length > 3248L) {
                    throw new RtrProtocolException(generateError.apply(ErrorCode.InvalidRequest, String.format("maximum PDU length is %d, was %d", 3248, length)), false);
                }
                if ((long)(in.readableBytes() + 8) < length) {
                    return Optional.empty();
                }
                long encapsulatedPduLength = in.readUnsignedInt();
                if (encapsulatedPduLength > length - 16L) {
                    throw new RtrProtocolException(generateError.apply(ErrorCode.InvalidRequest, String.format("encapsulated PDU length %d exceeds maximum length %d", encapsulatedPduLength, length - 16L)), false);
                }
                byte[] encapsulatedPdu = new byte[(int)encapsulatedPduLength];
                in.readBytes(encapsulatedPdu);
                long errorTextLength = in.readUnsignedInt();
                if (errorTextLength > length - encapsulatedPduLength - 16L) {
                    throw new RtrProtocolException(generateError.apply(ErrorCode.InvalidRequest, String.format("error text length %d exceeds maximum length %d", errorTextLength, length - encapsulatedPduLength - 16L)), false);
                }
                byte[] errorTextBytes = new byte[(int)errorTextLength];
                in.readBytes(errorTextBytes);
                return Optional.of(ErrorPdu.of((ProtocolVersion)protocolVersion, (ErrorCode)ErrorCode.of((int)errorCode), (byte[])encapsulatedPdu, (String)new String(errorTextBytes, StandardCharsets.UTF_8)));
            }
        }
        throw new RtrProtocolException(generateError.apply(ErrorCode.UnsupportedPduType, String.format("unsupported PDU type %d", pduType)));
    }

    private static boolean checkLength(ByteBuf in, int expectedLength, String pduType, BiFunction<ErrorCode, String, ErrorPdu> generateError) {
        long length = in.readUnsignedInt();
        if (length != (long)expectedLength) {
            throw new RtrProtocolException(generateError.apply(ErrorCode.InvalidRequest, String.format("length of %s PDU must be %d, was %d", pduType, expectedLength, length)));
        }
        return (long)(in.readableBytes() + 8) >= length;
    }
}

