% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.tabbook.R
\name{rk.XML.tabbook}
\alias{rk.XML.tabbook}
\title{Create XML node "tabbook" for RKWard plugins}
\usage{
rk.XML.tabbook(label = NULL, tabs = list(), id.name = "auto", i18n = NULL)
}
\arguments{
\item{label}{Character string, a text label for this plugin element.}

\item{tabs}{An optional named list with objects of class \code{XiMpLe.node} (or a list of these objects).
You must provide one named element for each tab. Use \code{NULL} for tabs without predefined children.}

\item{id.name}{Character vector, unique IDs for the tabbook (first entry) and all tabs.
If \code{"auto"}, IDs will be generated automatically from the labels.
If \code{NULL}, no IDs will be given.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "tabbook" for RKWard plugins
}
\note{
If a node in \code{tabs} is \code{<insert>}, it is returned as-is,
      without being nested in \code{<tab>}.
}
\examples{
test.checkboxes <- rk.XML.row(rk.XML.col(
  rk.XML.cbox(label="foo", val="foo1", chk=TRUE),
  rk.XML.cbox(label="bar", val="bar2")))
test.dropdown <- rk.XML.dropdown("mydrop",
  options=list("First Option"=c(val="val1"),
  "Second Option"=c(val="val2", chk=TRUE)))
# combine the above into a tabbook
test.tabbook <- rk.XML.tabbook("My Tabbook",
  tabs=list("First Tab"=test.checkboxes, "Second Tab"=test.dropdown))
cat(pasteXML(test.tabbook))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
