descriptiveStats <- function (data, groups=NULL, statistics = c("min", "max", "mean", "median", "Mode", "variance", "unvariance", "stdev", "sd", "cv", "ran", "iqrange", "skewness", "kurtosis", "quantiles"),
		quantiles = c(0, 0.25, 0.5, 0.75, 1), na.rm=TRUE, decimals=4) {
	require(e1071)
	require(plyr)
	data <- as.data.frame(data)
	if (!is.null(groups)) {
		for (i in 1:length(groups)) {
			if (!groups[i] %in% colnames(data)) {
				stop(paste(groups[i], "is not a column of data frame", data))
			}
			if (!is.factor(data[[groups[i]]])) {
				stop(paste(groups[i], "is not a factor"))
			}
		}
	}
	#statistics <- match.arg(statistics, c("min", "max", "mean", "median", "Mode", "variance", "unvariance", "stdev", "sd", "cv", "ran", "iqrange", "skewness", "kurtosis", "quantiles"), several.ok = TRUE)
	stats <- c(c(min, max, mean, median, Mode, variance, unvariance, stdev, sd, cv, ran, iqrange, skewness, kurtosis)
					[c("min", "max", "mean", "median", "Mode", "variance", "unvariance", "stdev", "sd", "cv", "ran", "iqrange", "skewness", "kurtosis") %in% statistics])
	if (length(stats)==1){
		stats <- stats[[1]]
	}
	names <- c(c("Min", "Max", "Mean", "Median", "Mode", "Variance", "Corrected variance", "Std.Deviation", "Corrected Std.Deviation", "Coef.Variation", "Range", "IQR", "Coef.Skewness", "Coef.Kurtosis")
					[c("min", "max", "mean", "median", "Mode", "variance", "unvariance", "stdev", "sd", "cv", "ran", "iqrange", "skewness", "kurtosis") %in% statistics])
	nmissing <- function(x) sum(is.na(x))
	nnomissing <- function(x) sum(!is.na(x))
	f <- function(df) {
		table <- NULL
		if (length(stats)>0){
			table <- colwise(each(stats))(df,na.rm=na.rm)
		}
		if ("quantiles" %in% statistics) {
			quantnames <- if (length(quantiles) >= 1) paste(100 * quantiles, "%", sep = "") else NULL
			table <- rbind(table,colwise(quantile)(df,probs=quantiles,na.rm=na.rm))
			names <- c(names, quantnames)
		}
		table <- rbind(table,colwise(each(nmissing,nnomissing))(df))
		names <- c(names, "Missing", "Valid")
		rownames(table) <- names
		table <- as.data.frame(t(table))
		table <- round(table,decimals)
	}
	if (is.null(groups)){
		result <- f(data)
	}
	else {
		result <- dlply(data,groups,f)
	}
	return(result)	
}
