/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.Round;

public class Substring
extends Function {
    public String getName() {
        return "substring";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        boolean bl;
        int n = this.checkArgumentCount(2, 3);
        this.argument[0] = this.argument[0].simplify();
        this.argument[1] = this.argument[1].simplify();
        boolean bl2 = bl = this.argument[0] instanceof Value && this.argument[1] instanceof Value;
        if (n == 3) {
            this.argument[2] = this.argument[2].simplify();
            boolean bl3 = bl = bl && this.argument[2] instanceof Value;
        }
        if (bl) {
            return this.evaluate(null);
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        double d = this.argument[1].evaluateAsNumber(context);
        if (this.getNumberOfArguments() == 2) {
            return Substring.substring(string, d);
        }
        double d2 = this.argument[2].evaluateAsNumber(context);
        return Substring.substring(string, d, d2);
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    private static String substring(String string, double d) {
        int n = string.length();
        int n2 = n - (int)d + 1;
        if (n2 < 0) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 1;
        int n4 = 0;
        double d2 = Round.round(d);
        while (n4 < n) {
            char c;
            if ((double)n3 >= d2) {
                stringBuffer.append(string.charAt(n4));
            }
            if ((c = string.charAt(n4++)) >= '\ud800' && c <= '\udbff') continue;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String substring(String string, double d, double d2) {
        int n = string.length();
        int n2 = (int)d2;
        if (n2 < 0) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 1;
        int n4 = 0;
        double d3 = Round.round(d);
        double d4 = Round.round(d2);
        while (n4 < n) {
            char c;
            if ((double)n3 >= d3) {
                if (!((double)n3 < d3 + d4)) break;
                stringBuffer.append(string.charAt(n4));
            }
            if ((c = string.charAt(n4++)) >= '\ud800' && c <= '\udbff') continue;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public int getDependencies() {
        int n = this.argument[0].getDependencies() | this.argument[1].getDependencies();
        if (this.getNumberOfArguments() == 3) {
            n |= this.argument[2].getDependencies();
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Substring substring = new Substring();
        substring.addArgument(this.argument[0].reduce(n, context));
        substring.addArgument(this.argument[1].reduce(n, context));
        if (this.getNumberOfArguments() == 3) {
            substring.addArgument(this.argument[2].reduce(n, context));
        }
        substring.setStaticContext(this.getStaticContext());
        return substring.simplify();
    }
}

