// Code generated by gqlclientgen - DO NOT EDIT.

package listssrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type ACL struct {
	// Permission to browse or subscribe to emails
	Browse bool `json:"browse"`
	// Permission to reply to existing threads
	Reply bool `json:"reply"`
	// Permission to start new threads
	Post bool `json:"post"`
	// Permission to moderate the list
	Moderate bool `json:"moderate"`

	// Underlying value of the GraphQL interface
	Value ACLValue `json:"-"`
}

func (base *ACL) UnmarshalJSON(b []byte) error {
	type Raw ACL
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "MailingListACL":
		base.Value = new(MailingListACL)
	case "GeneralACL":
		base.Value = new(GeneralACL)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface ACL: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// ACLValue is one of: MailingListACL | GeneralACL
type ACLValue interface {
	isACL()
}

type ACLInput struct {
	Browse   bool `json:"browse"`
	Reply    bool `json:"reply"`
	Post     bool `json:"post"`
	Moderate bool `json:"moderate"`
}

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessScope string

const (
	AccessScopeAcls          AccessScope = "ACLS"
	AccessScopeEmails        AccessScope = "EMAILS"
	AccessScopeLists         AccessScope = "LISTS"
	AccessScopePatches       AccessScope = "PATCHES"
	AccessScopeProfile       AccessScope = "PROFILE"
	AccessScopeSubscriptions AccessScope = "SUBSCRIPTIONS"
)

type ActivitySubscription struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`

	// Underlying value of the GraphQL interface
	Value ActivitySubscriptionValue `json:"-"`
}

func (base *ActivitySubscription) UnmarshalJSON(b []byte) error {
	type Raw ActivitySubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "MailingListSubscription":
		base.Value = new(MailingListSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface ActivitySubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// ActivitySubscriptionValue is one of: MailingListSubscription
type ActivitySubscriptionValue interface {
	isActivitySubscription()
}

// A cursor for enumerating subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ActivitySubscriptionCursor struct {
	Results []ActivitySubscription `json:"results"`
	Cursor  *Cursor                `json:"cursor,omitempty"`
}

// A byte range.
type ByteRange struct {
	// Inclusive start byte offset.
	Start int32 `json:"start"`
	// Exclusive end byte offset.
	End int32 `json:"end"`
}

// Opaque string
type Cursor string

type Email struct {
	Id int32 `json:"id"`
	// The entity which sent this email. Will be a User if it can be associated
	// with an account, or a Mailbox otherwise.
	Sender *Entity `json:"sender"`
	// Time we received this email (non-forgable).
	Received gqlclient.Time `json:"received"`
	// Time given by Date header (forgable).
	Date gqlclient.Time `json:"date,omitempty"`
	// The Subject header.
	Subject string `json:"subject"`
	// The Message-ID header, without angle brackets.
	MessageID string `json:"messageID"`
	// The In-Reply-To header, if present, without angle brackets.
	InReplyTo *string `json:"inReplyTo,omitempty"`
	// Provides the value (or values) of a specific header from this email. Note
	// that the returned value is coerced to UTF-8 and may be lossy under certain
	// circumstances.
	Header []string `json:"header"`
	// Retrieves the value of an address list header, such as To or Cc.
	AddressList []Mailbox `json:"addressList"`
	// The decoded text/plain message part of the email, i.e. email body.
	Body string `json:"body"`
	// A URL from which the full raw message envelope may be downloaded.
	Envelope URL          `json:"envelope"`
	Thread   *Thread      `json:"thread"`
	Parent   *Email       `json:"parent,omitempty"`
	Patch    *Patch       `json:"patch,omitempty"`
	Patchset *Patchset    `json:"patchset,omitempty"`
	List     *MailingList `json:"list"`
}

// A cursor for enumerating emails
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type EmailCursor struct {
	Results []Email `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type EmailEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Email *Email         `json:"email"`
}

func (*EmailEvent) isWebhookPayload() {}

type Entity struct {
	CanonicalName string `json:"canonicalName"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "Mailbox":
		base.Value = new(Mailbox)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User | Mailbox
type EntityValue interface {
	isEntity()
}

// An ACL entry that applies "generally", for example the rights which apply to
// all subscribers to a list.
type GeneralACL struct {
	Browse   bool `json:"browse"`
	Reply    bool `json:"reply"`
	Post     bool `json:"post"`
	Moderate bool `json:"moderate"`
}

func (*GeneralACL) isACL() {}

// A mailbox not associated with a registered user
type Mailbox struct {
	CanonicalName string `json:"canonicalName"`
	Name          string `json:"name"`
	Address       string `json:"address"`
}

func (*Mailbox) isEntity() {}

type MailingList struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	Updated     gqlclient.Time `json:"updated"`
	Name        string         `json:"name"`
	Owner       *Entity        `json:"owner"`
	Description *string        `json:"description,omitempty"`
	Visibility  Visibility     `json:"visibility"`
	// List of globs for permitted or rejected mimetypes on this list
	// e.g. text/*
	PermitMime []string `json:"permitMime"`
	RejectMime []string `json:"rejectMime"`
	// List of threads on this list in order of most recently bumped
	Threads *ThreadCursor `json:"threads"`
	// List of emails received on this list in reverse chronological order
	Emails *EmailCursor `json:"emails"`
	// List of patches received on this list in order of most recently bumped
	Patches *PatchsetCursor `json:"patches"`
	// True if an import operation is underway for this list
	Importing bool `json:"importing"`
	// The access that applies to this user for this list
	Access *ACL `json:"access"`
	// The user's subscription for this list, if any
	Subscription *MailingListSubscription `json:"subscription,omitempty"`
	// URLs to application/mbox archives for this mailing list
	Archive    URL `json:"archive"`
	Last30days URL `json:"last30days"`
	// Access control list entries for this mailing list
	Acl        *MailingListACLCursor `json:"acl"`
	DefaultACL *GeneralACL           `json:"defaultACL"`
	// Returns a list of mailing list webhook subscriptions. For clients
	// authenticated with a personal access token, this returns all webhooks
	// configured by all GraphQL clients for your account. For clients
	// authenticated with an OAuth 2.0 access token, this returns only webhooks
	// registered for your client.
	Webhooks *WebhookSubscriptionCursor `json:"webhooks"`
	// Returns details of a mailing list webhook subscription by its ID.
	Webhook *WebhookSubscription `json:"webhook,omitempty"`
}

// These ACLs are configured for specific entities, and may be used to expand or
// constrain the rights of a participant.
type MailingListACL struct {
	Id       int32          `json:"id"`
	Created  gqlclient.Time `json:"created"`
	List     *MailingList   `json:"list"`
	Entity   *Entity        `json:"entity"`
	Browse   bool           `json:"browse"`
	Reply    bool           `json:"reply"`
	Post     bool           `json:"post"`
	Moderate bool           `json:"moderate"`
}

func (*MailingListACL) isACL() {}

// A cursor for enumerating ACL entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type MailingListACLCursor struct {
	Results []MailingListACL `json:"results"`
	Cursor  *Cursor          `json:"cursor,omitempty"`
}

// A cursor for enumerating mailing lists
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type MailingListCursor struct {
	Results []MailingList `json:"results"`
	Cursor  *Cursor       `json:"cursor,omitempty"`
}

type MailingListEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	List  *MailingList   `json:"list"`
}

func (*MailingListEvent) isWebhookPayload() {}

type MailingListInput struct {
	Description *string     `json:"description,omitempty"`
	Visibility  *Visibility `json:"visibility,omitempty"`
	// List of globs for permitted or rejected mimetypes on this list
	// e.g. text/*
	PermitMime []string `json:"permitMime,omitempty"`
	RejectMime []string `json:"rejectMime,omitempty"`
}

type MailingListSubscription struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	List    *MailingList   `json:"list"`
}

func (*MailingListSubscription) isActivitySubscription() {}

type MailingListWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type MailingListWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
	List       *MailingList           `json:"list"`
}

func (*MailingListWebhookSubscription) isWebhookSubscription() {}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

// Information parsed from the subject line of a patch, such that the following:
//
//     [PATCH myproject v2 3/4] Add foo to bar
//
// Will produce:
//
//     index: 3
//     count: 4
//     version: 2
//     prefix: "myproject"
//     subject: "Add foo to bar"
type Patch struct {
	Index   *int32  `json:"index,omitempty"`
	Count   *int32  `json:"count,omitempty"`
	Version *int32  `json:"version,omitempty"`
	Prefix  *string `json:"prefix,omitempty"`
	Subject *string `json:"subject,omitempty"`
}

type Patchset struct {
	Id           int32          `json:"id"`
	Created      gqlclient.Time `json:"created"`
	Updated      gqlclient.Time `json:"updated"`
	Subject      string         `json:"subject"`
	Version      int32          `json:"version"`
	Prefix       *string        `json:"prefix,omitempty"`
	Status       PatchsetStatus `json:"status"`
	Submitter    *Entity        `json:"submitter"`
	CoverLetter  *Email         `json:"coverLetter,omitempty"`
	Thread       *Thread        `json:"thread"`
	SupersededBy *Patchset      `json:"supersededBy,omitempty"`
	List         *MailingList   `json:"list"`
	Patches      *EmailCursor   `json:"patches"`
	Tools        []PatchsetTool `json:"tools"`
	// URL to an application/mbox archive of only the patches in this thread
	Mbox URL `json:"mbox"`
}

// A cursor for enumerating patchsets
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type PatchsetCursor struct {
	Results []Patchset `json:"results"`
	Cursor  *Cursor    `json:"cursor,omitempty"`
}

type PatchsetEvent struct {
	Uuid     string         `json:"uuid"`
	Event    WebhookEvent   `json:"event"`
	Date     gqlclient.Time `json:"date"`
	Patchset *Patchset      `json:"patchset"`
}

func (*PatchsetEvent) isWebhookPayload() {}

type PatchsetStatus string

const (
	PatchsetStatusUnknown       PatchsetStatus = "UNKNOWN"
	PatchsetStatusProposed      PatchsetStatus = "PROPOSED"
	PatchsetStatusNeedsRevision PatchsetStatus = "NEEDS_REVISION"
	PatchsetStatusSuperseded    PatchsetStatus = "SUPERSEDED"
	PatchsetStatusApproved      PatchsetStatus = "APPROVED"
	PatchsetStatusRejected      PatchsetStatus = "REJECTED"
	PatchsetStatusApplied       PatchsetStatus = "APPLIED"
)

// Used to add some kind of indicator for a third-party process associated with
// a patchset, such as a CI service validating the change.
type PatchsetTool struct {
	Id       int32          `json:"id"`
	Created  gqlclient.Time `json:"created"`
	Updated  gqlclient.Time `json:"updated"`
	Icon     ToolIcon       `json:"icon"`
	Details  string         `json:"details"`
	Patchset *Patchset      `json:"patchset"`
}

type Thread struct {
	Created      gqlclient.Time `json:"created"`
	Updated      gqlclient.Time `json:"updated"`
	Subject      string         `json:"subject"`
	Replies      int32          `json:"replies"`
	Participants int32          `json:"participants"`
	Sender       *Entity        `json:"sender"`
	Root         *Email         `json:"root"`
	List         *MailingList   `json:"list"`
	// Replies to this thread, in chronological order
	Descendants *EmailCursor `json:"descendants"`
	// A mailto: URI for replying to the latest message in this thread
	Mailto string `json:"mailto"`
	// URL to an application/mbox archive of this thread
	Mbox URL `json:"mbox"`
	// Thread parsed as a tree.
	//
	// The returned list is never empty. The first item is guaranteed to be the root
	// message. The blocks are sorted in topological order.
	Blocks []ThreadBlock `json:"blocks"`
}

// A block of text in an email thread.
//
// Blocks are parts of a message's body that aren't quotes of the parent message.
// A block can be a reply to a parent block, in which case the parentStart and
// parentEnd fields indicate which part of the parent message is replied to. A
// block can have replies, each of which will be represented by a block in the
// children field.
type ThreadBlock struct {
	// Unique identifier for this block.
	Key string `json:"key"`
	// The block's plain-text content.
	Body string `json:"body"`
	// Index of the parent block (if any) in Thread.blocks.
	Parent *int32 `json:"parent,omitempty"`
	// Replies to this block.
	//
	// The list items are indexes into Thread.blocks.
	Children []int32 `json:"children"`
	// The email this block comes from.
	Source *Email `json:"source"`
	// The range of this block in the source email body.
	SourceRange *ByteRange `json:"sourceRange"`
	// If this block is a reply to a particular chunk of the parent block, this
	// field indicates the range of that chunk in the parent's email body.
	ParentRange *ByteRange `json:"parentRange,omitempty"`
}

// A cursor for enumerating threads
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ThreadCursor struct {
	Results []Thread `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type ToolIcon string

const (
	ToolIconPending   ToolIcon = "PENDING"
	ToolIconWaiting   ToolIcon = "WAITING"
	ToolIconSuccess   ToolIcon = "SUCCESS"
	ToolIconFailed    ToolIcon = "FAILED"
	ToolIconCancelled ToolIcon = "CANCELLED"
)

// URL from which some secondary data may be retrieved. You must provide the
// same Authentication header to this address as you did to the GraphQL resolver
// which provided it. The URL is not guaranteed to be consistent for an extended
// length of time; applications should submit a new GraphQL query each time they
// wish to access the data at the provided URL.
type URL string

// A registered user
type User struct {
	Id            int32              `json:"id"`
	Created       gqlclient.Time     `json:"created"`
	Updated       gqlclient.Time     `json:"updated"`
	CanonicalName string             `json:"canonicalName"`
	Username      string             `json:"username"`
	Email         string             `json:"email"`
	Url           *string            `json:"url,omitempty"`
	Location      *string            `json:"location,omitempty"`
	Bio           *string            `json:"bio,omitempty"`
	List          *MailingList       `json:"list,omitempty"`
	Lists         *MailingListCursor `json:"lists"`
	Emails        *EmailCursor       `json:"emails"`
	Threads       *ThreadCursor      `json:"threads"`
	Patches       *PatchsetCursor    `json:"patches"`
}

func (*User) isEntity() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
}

type Visibility string

const (
	VisibilityPublic   Visibility = "PUBLIC"
	VisibilityUnlisted Visibility = "UNLISTED"
	VisibilityPrivate  Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventListCreated      WebhookEvent = "LIST_CREATED"
	WebhookEventListUpdated      WebhookEvent = "LIST_UPDATED"
	WebhookEventListDeleted      WebhookEvent = "LIST_DELETED"
	WebhookEventEmailReceived    WebhookEvent = "EMAIL_RECEIVED"
	WebhookEventPatchsetReceived WebhookEvent = "PATCHSET_RECEIVED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "MailingListEvent":
		base.Value = new(MailingListEvent)
	case "EmailEvent":
		base.Value = new(EmailEvent)
	case "PatchsetEvent":
		base.Value = new(PatchsetEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: MailingListEvent | EmailEvent | PatchsetEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "MailingListWebhookSubscription":
		base.Value = new(MailingListWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription | MailingListWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func DeleteMailingList(client *gqlclient.Client, ctx context.Context, id int32) (deleteMailingList *MailingList, err error) {
	op := gqlclient.NewOperation("mutation deleteMailingList ($id: Int!) {\n\tdeleteMailingList(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteMailingList *MailingList
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteMailingList, err
}

func MailingLists(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query mailingLists ($cursor: Cursor) {\n\tme {\n\t\tlists(cursor: $cursor) {\n\t\t\t... lists\n\t\t}\n\t}\n}\nfragment lists on MailingListCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ExportMailingList(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query exportMailingList ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\t... mailingListExport\n\t\t}\n\t}\n}\nfragment mailingListExport on MailingList {\n\tname\n\tdescription\n\tvisibility\n\tpermitMime\n\trejectMime\n\tarchive\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportMailingLists(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query exportMailingLists ($cursor: Cursor) {\n\tme {\n\t\tlists(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\t... mailingListExport\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\nfragment mailingListExport on MailingList {\n\tname\n\tdescription\n\tvisibility\n\tpermitMime\n\trejectMime\n\tarchive\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func MailingListsByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query mailingListsByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\tlists(cursor: $cursor) {\n\t\t\t... lists\n\t\t}\n\t}\n}\nfragment lists on MailingListCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func MailingListIDByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query mailingListIDByName ($name: String!) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func MailingListIDByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query mailingListIDByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ListPatches(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query listPatches ($name: String!, $cursor: Cursor) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\t... patchsetsByList\n\t\t}\n\t}\n}\nfragment patchsetsByList on MailingList {\n\tpatches(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tcreated\n\t\t\tversion\n\t\t\tprefix\n\t\t\tsubmitter {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListPatchesByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query listPatchesByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\t... patchsetsByList\n\t\t}\n\t}\n}\nfragment patchsetsByList on MailingList {\n\tpatches(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tcreated\n\t\t\tversion\n\t\t\tprefix\n\t\t\tsubmitter {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Patches(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query patches ($cursor: Cursor) {\n\tme {\n\t\t... patchsets\n\t}\n}\nfragment patchsets on User {\n\tpatches(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tcreated\n\t\t\tversion\n\t\t\tprefix\n\t\t\tlist {\n\t\t\t\tname\n\t\t\t\towner {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func PatchesByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query patchesByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\t... patchsets\n\t}\n}\nfragment patchsets on User {\n\tpatches(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tcreated\n\t\t\tversion\n\t\t\tprefix\n\t\t\tlist {\n\t\t\t\tname\n\t\t\t\towner {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func PatchsetById(client *gqlclient.Client, ctx context.Context, id int32, cursor *Cursor) (patchset *Patchset, err error) {
	op := gqlclient.NewOperation("query patchsetById ($id: Int!, $cursor: Cursor) {\n\tpatchset(id: $id) {\n\t\tpatches(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tdate\n\t\t\t\tbody\n\t\t\t\tsubject\n\t\t\t\theader(want: \"From\")\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	op.Var("cursor", cursor)
	var respData struct {
		Patchset *Patchset
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Patchset, err
}

func CompletePatchsetId(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query completePatchsetId ($name: String!) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\t... completePatchset\n\t\t}\n\t}\n}\nfragment completePatchset on MailingList {\n\tpatches {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tversion\n\t\t\tprefix\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompletePatchsetIdByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query completePatchsetIdByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\t... completePatchset\n\t\t}\n\t}\n}\nfragment completePatchset on MailingList {\n\tpatches {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\tstatus\n\t\t\tversion\n\t\t\tprefix\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func AclByListName(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query aclByListName ($name: String!, $cursor: Cursor) {\n\tme {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\tlist(name: $name) {\n\t\tdefaultACL {\n\t\t\tbrowse\n\t\t\treply\n\t\t\tpost\n\t\t\tmoderate\n\t\t}\n\t\tacl(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tbrowse\n\t\t\t\treply\n\t\t\t\tpost\n\t\t\t\tmoderate\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func AclByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query aclByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\tlist(name: $name) {\n\t\tdefaultACL {\n\t\t\tbrowse\n\t\t\treply\n\t\t\tpost\n\t\t\tmoderate\n\t\t}\n\t\tacl(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tbrowse\n\t\t\t\treply\n\t\t\t\tpost\n\t\t\t\tmoderate\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func Archive(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query archive ($name: String!) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\tarchive\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ArchiveByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query archiveByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\tarchive\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteLists(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query completeLists {\n\tme {\n\t\tlists {\n\t\t\tresults {\n\t\t\t\tname\n\t\t\t}\n\t\t}\n\t}\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func MailingListWebhooks(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query mailingListWebhooks ($name: String!, $cursor: Cursor) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\t... mailingListWebhooks\n\t\t}\n\t}\n}\nfragment mailingListWebhooks on MailingList {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func MailingListWebhooksByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query mailingListWebhooksByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\t... mailingListWebhooks\n\t\t}\n\t}\n}\nfragment mailingListWebhooks on MailingList {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Subscriptions(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (subscriptions *ActivitySubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query subscriptions ($cursor: Cursor) {\n\tsubscriptions(cursor: $cursor) {\n\t\tresults {\n\t\t\tcreated\n\t\t\t__typename\n\t\t\t... on MailingListSubscription {\n\t\t\t\tlist {\n\t\t\t\t\tname\n\t\t\t\t\towner {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Subscriptions *ActivitySubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Subscriptions, err
}

func MailingListDescription(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query mailingListDescription ($name: String!) {\n\tme {\n\t\tlist(name: $name) {\n\t\t\tdescription\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func MailingListDescriptionByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query mailingListDescriptionByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\tlist(name: $name) {\n\t\t\tdescription\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func MailingListSubscribe(client *gqlclient.Client, ctx context.Context, listID int32) (mailingListSubscribe *MailingListSubscription, err error) {
	op := gqlclient.NewOperation("mutation mailingListSubscribe ($listID: Int!) {\n\tmailingListSubscribe(listID: $listID) {\n\t\tlist {\n\t\t\tname\n\t\t\towner {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("listID", listID)
	var respData struct {
		MailingListSubscribe *MailingListSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.MailingListSubscribe, err
}

func MailingListUnsubscribe(client *gqlclient.Client, ctx context.Context, listID int32) (mailingListUnsubscribe *MailingListSubscription, err error) {
	op := gqlclient.NewOperation("mutation mailingListUnsubscribe ($listID: Int!) {\n\tmailingListUnsubscribe(listID: $listID) {\n\t\tlist {\n\t\t\tname\n\t\t\towner {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("listID", listID)
	var respData struct {
		MailingListUnsubscribe *MailingListSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.MailingListUnsubscribe, err
}

func UpdatePatchset(client *gqlclient.Client, ctx context.Context, id int32, status PatchsetStatus) (updatePatchset *Patchset, err error) {
	op := gqlclient.NewOperation("mutation updatePatchset ($id: Int!, $status: PatchsetStatus!) {\n\tupdatePatchset(id: $id, status: $status) {\n\t\tsubmitter {\n\t\t\tcanonicalName\n\t\t}\n\t\tsubject\n\t}\n}\n")
	op.Var("id", id)
	op.Var("status", status)
	var respData struct {
		UpdatePatchset *Patchset
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdatePatchset, err
}

func DeleteACL(client *gqlclient.Client, ctx context.Context, id int32) (deleteACL *MailingListACL, err error) {
	op := gqlclient.NewOperation("mutation deleteACL ($id: Int!) {\n\tdeleteACL(id: $id) {\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t\tlist {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteACL *MailingListACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteACL, err
}

func CreateMailingList(client *gqlclient.Client, ctx context.Context, name string, description *string, visibility Visibility) (createMailingList *MailingList, err error) {
	op := gqlclient.NewOperation("mutation createMailingList ($name: String!, $description: String, $visibility: Visibility!) {\n\tcreateMailingList(name: $name, description: $description, visibility: $visibility) {\n\t\tid\n\t\tname\n\t}\n}\n")
	op.Var("name", name)
	op.Var("description", description)
	op.Var("visibility", visibility)
	var respData struct {
		CreateMailingList *MailingList
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateMailingList, err
}

func UpdateMailingList(client *gqlclient.Client, ctx context.Context, id int32, input MailingListInput) (updateMailingList *MailingList, err error) {
	op := gqlclient.NewOperation("mutation updateMailingList ($id: Int!, $input: MailingListInput!) {\n\tupdateMailingList(id: $id, input: $input) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	op.Var("input", input)
	var respData struct {
		UpdateMailingList *MailingList
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateMailingList, err
}

func ClearDescription(client *gqlclient.Client, ctx context.Context, id int32) (updateMailingList *MailingList, err error) {
	op := gqlclient.NewOperation("mutation clearDescription ($id: Int!) {\n\tupdateMailingList(id: $id, input: {description:null}) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateMailingList *MailingList
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateMailingList, err
}

func ImportMailingListSpool(client *gqlclient.Client, ctx context.Context, id int32, spool gqlclient.Upload) (importMailingListSpool bool, err error) {
	op := gqlclient.NewOperation("mutation importMailingListSpool ($id: Int!, $spool: Upload!) {\n\timportMailingListSpool(listID: $id, spool: $spool)\n}\n")
	op.Var("id", id)
	op.Var("spool", spool)
	var respData struct {
		ImportMailingListSpool bool
	}
	err = client.Execute(ctx, op, &respData)
	return respData.ImportMailingListSpool, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func CreateMailingListWebhook(client *gqlclient.Client, ctx context.Context, listId int32, config MailingListWebhookInput) (createMailingListWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createMailingListWebhook ($listId: Int!, $config: MailingListWebhookInput!) {\n\tcreateMailingListWebhook(listId: $listId, config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("listId", listId)
	op.Var("config", config)
	var respData struct {
		CreateMailingListWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateMailingListWebhook, err
}

func DeleteMailingListWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteMailingListWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteMailingListWebhook ($id: Int!) {\n\tdeleteMailingListWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteMailingListWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteMailingListWebhook, err
}
