/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import org.dbdoclet.io.MimeType;

/**
 * Eine ComboBox mit einer Liste von oft verwendeten MimeTypes. Im Modell der
 * ComboBox werden Objekte des Types {@link org.dbdoclet.io.MimeType}
 * gespeichert.
 * 
 * @author mfuchs
 */
public class MimeTypeListBox extends JComboBox<MimeType> {

    private static final long serialVersionUID = 1L;
    private DefaultComboBoxModel<MimeType> model;
    
    public static final int ALL = 0x0001;
    public static final int PICTURES = 0x0002;
    
    public MimeTypeListBox() {

	model = new DefaultComboBoxModel<MimeType>();
	addAllMimeTypes();
	setModel(model);
    }

    public MimeType getSelectedMimeType() {
	return (MimeType) getSelectedItem();
    }

    public void setSelectedMimeType(String mimeType) {

	MimeType mimeTypeItem = MimeType.valueOf(mimeType);
	setSelectedItem(mimeTypeItem);
    }
    
    public void setMimeTypeGroup(int groupMode) {
	
	if (groupMode == PICTURES) {
	
	    model.removeAllElements();
	    model.addElement(MimeType.GIF);
	    model.addElement(MimeType.JPEG);
	    model.addElement(MimeType.PNG);
	}
	
	if (groupMode == ALL) {
	    addAllMimeTypes();
	}
    }

    private void addAllMimeTypes() {
	
	model.removeAllElements();
	model.addElement(MimeType.CSV);
	model.addElement(MimeType.DOC);
	model.addElement(MimeType.DOCX);
	model.addElement(MimeType.GIF);
	model.addElement(MimeType.HTML);
	model.addElement(MimeType.JPEG);
	model.addElement(MimeType.MIDI);
	model.addElement(MimeType.MP3);
	model.addElement(MimeType.MPEG);
	model.addElement(MimeType.ODP);
	model.addElement(MimeType.ODS);
	model.addElement(MimeType.ODT);
	model.addElement(MimeType.PDF);
	model.addElement(MimeType.PNG);
	model.addElement(MimeType.POD);
	model.addElement(MimeType.PPT);
	model.addElement(MimeType.PPTX);
	model.addElement(MimeType.PPTM);
	model.addElement(MimeType.POTX);
	model.addElement(MimeType.WAV);
	model.addElement(MimeType.WMV);
	model.addElement(MimeType.XLS);
	model.addElement(MimeType.XLSX);
    }
}
