;;;; -*- mode: lisp; indent-tabs-mode: nil -*-
#+ccl
(in-package :ccl)

#+(and ccl x86-64 ironclad-assembly)
(progn
  (defx86lapfunction ironclad::%ub32ref/le ((vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movl (@ x8664::misc-data-offset (% vector)) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%ub32set/le ((value arg_x) (vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (unbox-fixnum value imm1)
    (addq (% imm0) (% vector))
    (movl (% imm1.l) (@ x8664::misc-data-offset (% vector)))
    (retq))

  (defx86lapfunction ironclad::%ub32ref/be ((vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movl (@ x8664::misc-data-offset (% vector)) (% imm0.l))
    (bswapl (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%ub32set/be ((value arg_x) (vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (unbox-fixnum value imm1)
    (bswapl (% imm1.l))
    (addq (% imm0) (% vector))
    (movl (% imm1.l) (@ x8664::misc-data-offset (% vector)))
    (retq))

  (defx86lapfunction ironclad::%ub64ref/le ((vector arg_y) (offset arg_z))
    (save-simple-frame)
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movq (@ x8664::misc-data-offset (% vector)) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%ub64set/le ((value arg_x) (vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movq (% value) (% arg_z))
    (call-subprim .SPgetu64)
    (movq (% imm0) (@ x8664::misc-data-offset (% vector)))
    (retq))

  (defx86lapfunction ironclad::%ub64ref/be ((vector arg_y) (offset arg_z))
    (save-simple-frame)
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movq (@ x8664::misc-data-offset (% vector)) (% imm0))
    (bswapq (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%ub64set/be ((value arg_x) (vector arg_y) (offset arg_z))
    (unbox-fixnum offset imm0)
    (addq (% imm0) (% vector))
    (movq (% value) (% arg_z))
    (call-subprim .SPgetu64)
    (bswapq (% imm0))
    (movq (% imm0) (@ x8664::misc-data-offset (% vector)))
    (retq))

  (defx86lapfunction ironclad::%mod32+ ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (addl (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%mod32- ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (subl (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%mod32* ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (imull (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%mod32ash ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (testb (% imm2.b) (% imm2.b))
    (js :right)
    (shll (% imm2.b) (% imm0.l))
    (jmp :end)
    :right
    (negb (% imm2.b))
    (shrl (% imm2.b) (% imm0.l))
    :end
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%mod32lognot ((number arg_z))
    (unbox-fixnum number imm0)
    (notl (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%rol32 ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (roll (% imm2.b) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%ror32 ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (rorl (% imm2.b) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ironclad::%mod64+ ((a arg_y) (b arg_z))
    (save-simple-frame)
    (call-subprim .SPgetu64)
    (movq (% imm0) (% imm1))
    (movq (% a) (% arg_z))
    (call-subprim .SPgetu64)
    (addq (% imm1) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%mod64- ((a arg_y) (b arg_z))
    (save-simple-frame)
    (call-subprim .SPgetu64)
    (movq (% imm0) (% imm1))
    (movq (% a) (% arg_z))
    (call-subprim .SPgetu64)
    (subq (% imm1) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%mod64* ((a arg_y) (b arg_z))
    (save-simple-frame)
    (call-subprim .SPgetu64)
    (movq (% imm0) (% imm1))
    (movq (% a) (% arg_z))
    (call-subprim .SPgetu64)
    (imulq (% imm1) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%mod64ash ((number arg_y) (count arg_z))
    (save-simple-frame)
    (unbox-fixnum count imm2)
    (movq (% number) (% arg_z))
    (call-subprim .SPgetu64)
    (testb (% imm2.b) (% imm2.b))
    (js :right)
    (shlq (% imm2.b) (% imm0))
    (jmp :end)
    :right
    (negb (% imm2.b))
    (shrq (% imm2.b) (% imm0))
    :end
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%mod64lognot ((number arg_z))
    (save-simple-frame)
    (call-subprim .SPgetu64)
    (notq (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%rol64 ((number arg_y) (count arg_z))
    (save-simple-frame)
    (unbox-fixnum count imm2)
    (movq (% number) (% arg_z))
    (call-subprim .SPgetu64)
    (rolq (% imm2.b) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64))

  (defx86lapfunction ironclad::%ror64 ((number arg_y) (count arg_z))
    (save-simple-frame)
    (unbox-fixnum count imm2)
    (movq (% number) (% arg_z))
    (call-subprim .SPgetu64)
    (rorq (% imm2.b) (% imm0))
    (restore-simple-frame)
    (jmp-subprim .SPmakeu64)))
