/**
 * \file
 * \brief Contains default ADRV9001 Rx correction and compensation gain tables 
 *        to be used when an external LNA is connected
 *
 * ADRV9001 API Version: $ADI_ADRV9001_API_VERSION$
 */

 /**
 * Copyright 2021 Analog Devices Inc.
 * Released under the ADRV9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADRV9001_RX_GAIN_TABLE_H_
#define _ADRV9001_RX_GAIN_TABLE_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "adi_adrv9001_rx_types.h"

/* Gain correction and compensation tables to be used when an external LNA is connected */
static const adi_adrv9001_RxGainTableRow_t defaultGainCorrectionTable[69] = { 
   {251, 0, 0, 13, 0, }, {251, 0, 0,  23, 0,}, {250, 0, 0, -4, 0, }, {250, 0, 0,   6, 0,},
   {250, 0, 0, 16, 0, }, {249, 0, 0,  -7, 0,}, {249, 0, 0,  3, 0, }, {248, 0, 0, -12, 0,},
   {248, 0, 0,  -2, 0,}, {247, 0, 0, -17, 0,}, {247, 0, 0, -7, 0, }, {246, 0, 0, -16, 0,},
   {246, 0, 0,  -6, 0,}, {245, 0, 0, -15, 0,}, {245, 0, 0, -5, 0, }, {244, 0, 0, -10, 0,},
   {243, 0, 0, -16, 0,}, {242, 0, 0, -19, 0,}, {242, 0, 0, -10, 0,}, {241, 0, 0, -13, 0,},
   {240, 0, 0, -14, 0,}, {239, 0, 0, -16, 0,}, {238, 0, 0, -16, 0,}, {237, 0, 0, -16, 0,},
   {236, 0, 0, -15, 0,}, {234, 0, 0, -22, 0,}, {233, 0, 0, -20, 0,}, {232, 0, 0, -17, 0,},
   {230, 0, 0, -22, 0,}, {229, 0, 0, -19, 0,}, {227, 0, 0, -21, 0,}, {226, 0, 0, -17, 0,},
   {224, 0, 0, -18, 0,}, {222, 0, 0, -18, 0,}, {220, 0, 0, -18, 0,}, {218, 0, 0, -17, 0,},
   {215, 0, 0, -21, 0,}, {213, 0, 0, -19, 0,}, {210, 0, 0, -21, 0,}, {208, 0, 0, -18, 0,},
   {205, 0, 0, -18, 0,}, {202, 0, 0, -18, 0,}, {199, 0, 0, -17, 0,}, {195, 0, 0, -19, 0,},
   {192, 0, 0, -17, 0,}, {188, 0, 0, -16, 0,}, {184, 0, 0, -16, 0,}, {180, 0, 0, -15, 0,},
   {175, 0, 0, -16, 0,}, {170, 0, 0, -15, 0,}, {165, 0, 0, -15, 0,}, {160, 0, 0, -14, 0,},
   {154, 0, 0, -14, 0,}, {148, 0, 0, -13, 0,}, {142, 0, 0, -12, 0,}, {135, 0, 0, -12, 0,},
   {128, 0, 0, -11, 0,}, {120, 0, 0, -10, 0,}, {112, 0, 0, -10, 0,}, {104, 0, 0,  -8, 0,},
   { 94, 0, 0,  -9, 0,}, { 85, 0, 0,  -7, 0,}, { 75, 0, 0,  -6, 0,}, { 64, 0, 0,  -5, 0,},
   { 53, 0, 0,  -4, 0,}, { 41, 0, 0,  -3, 0,}, { 28, 0, 0,  -2, 0,}, { 14, 0, 0,  -1, 0,},
   {0, 0, 0, 0, 0,}
};

static const adi_adrv9001_RxGainTableRow_t defaultGainCompensationTable[69] = {
    {251, 0, 0, 693, 0,}, {251, 0, 0, 693, 0,}, {250, 0, 0, 656, 0,}, {250, 0, 0, 656, 0,},
    {250, 0, 0, 656, 0,}, {249, 0, 0, 623, 0,}, {249, 0, 0, 623, 0,}, {248, 0, 0, 598, 0,},
    {248, 0, 0, 598, 0,}, {247, 0, 0, 573, 0,}, {247, 0, 0, 573, 0,}, {246, 0, 0, 554, 0,},
    {246, 0, 0, 554, 0,}, {245, 0, 0, 535, 0,}, {245, 0, 0, 535, 0,}, {244, 0, 0, 520, 0,},
    {243, 0, 0, 504, 0,}, {242, 0, 0, 491, 0,}, {242, 0, 0, 490, 0,}, {241, 0, 0, 477, 0,},
    {240, 0, 0, 466, 0,}, {239, 0, 0, 454, 0,}, {238, 0, 0, 444, 0,}, {237, 0, 0, 434, 0,},
    {236, 0, 0, 425, 0,}, {234, 0, 0, 408, 0,}, {233, 0, 0, 400, 0,}, {232, 0, 0, 393, 0,},
    {230, 0, 0, 378, 0,}, {229, 0, 0, 371, 0,}, {227, 0, 0, 359, 0,}, {226, 0, 0, 353, 0,},
    {224, 0, 0, 342, 0,}, {222, 0, 0, 332, 0,}, {220, 0, 0, 322, 0,}, {218, 0, 0, 313, 0,},
    {215, 0, 0, 299, 0,}, {213, 0, 0, 291, 0,}, {210, 0, 0, 279, 0,}, {208, 0, 0, 272, 0,},
    {205, 0, 0, 262, 0,}, {202, 0, 0, 252, 0,}, {199, 0, 0, 243, 0,}, {195, 0, 0, 231, 0,},
    {192, 0, 0, 223, 0,}, {188, 0, 0, 214, 0,}, {184, 0, 0, 204, 0,}, {180, 0, 0, 195, 0,},
    {175, 0, 0, 184, 0,}, {170, 0, 0, 175, 0,}, {165, 0, 0, 165, 0,}, {160, 0, 0, 156, 0,},
    {154, 0, 0, 146, 0,}, {148, 0, 0, 137, 0,}, {142, 0, 0, 128, 0,}, {135, 0, 0, 118, 0,},
    {128, 0, 0, 109, 0,}, {120, 0, 0, 100, 0,}, {112, 0, 0,  90, 0,}, {104, 0, 0,  82, 0,},
    { 94, 0, 0,  71, 0,}, { 85, 0, 0,  63, 0,}, { 75, 0, 0,  54, 0,}, { 64, 0, 0,  45, 0,},
    { 53, 0, 0,  36, 0,}, { 41, 0, 0,  27, 0,}, { 28, 0, 0,  18, 0,}, { 14, 0, 0,   9, 0,},
    {0, 0, 0, 0, 0,}
};

#ifdef __cplusplus
}
#endif

#endif // _ADRV9001_RX_GAIN_TABLE_H_