/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgInheritedColumn;
import cz.startnet.utils.pgdiff.schema.PgRelationPrivilege;
import cz.startnet.utils.pgdiff.schema.PgRule;
import cz.startnet.utils.pgdiff.schema.PgTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PgRelation {
    protected final List<PgColumn> columns = new ArrayList<PgColumn>();
    private final List<PgIndex> indexes = new ArrayList<PgIndex>();
    private final List<PgTrigger> triggers = new ArrayList<PgTrigger>();
    private final List<PgRule> rules = new ArrayList<PgRule>();
    private String clusterIndexName;
    protected String name;
    protected String tablespace;
    String comment;
    private final List<PgRelationPrivilege> privileges = new ArrayList<PgRelationPrivilege>();
    private String ownerTo;

    public void setClusterIndexName(String string) {
        this.clusterIndexName = string;
    }

    public String getClusterIndexName() {
        return this.clusterIndexName;
    }

    public PgColumn getColumn(String string) {
        for (PgColumn pgColumn : this.columns) {
            if (!pgColumn.getName().equals(string)) continue;
            return pgColumn;
        }
        return null;
    }

    public List<PgColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    protected String getCommentDefinitionSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON ");
            stringBuilder.append(this.getRelationKind());
            stringBuilder.append(' ');
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        for (PgColumn pgColumn : this.columns) {
            if (pgColumn.getComment() == null || pgColumn.getComment().isEmpty()) continue;
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON COLUMN ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append('.');
            stringBuilder.append(PgDiffUtils.getQuotedName(pgColumn.getName()));
            stringBuilder.append(" IS ");
            stringBuilder.append(pgColumn.getComment());
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public PgIndex getIndex(String string) {
        for (PgIndex pgIndex : this.indexes) {
            if (!pgIndex.getName().equals(string)) continue;
            return pgIndex;
        }
        return null;
    }

    public PgTrigger getTrigger(String string) {
        for (PgTrigger pgTrigger : this.triggers) {
            if (!pgTrigger.getName().equals(string)) continue;
            return pgTrigger;
        }
        return null;
    }

    public List<PgIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public List<PgTrigger> getTriggers() {
        return Collections.unmodifiableList(this.triggers);
    }

    public List<PgRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = string;
    }

    public void addColumn(PgColumn pgColumn) {
        this.columns.add(pgColumn);
    }

    public void addIndex(PgIndex pgIndex) {
        this.indexes.add(pgIndex);
    }

    public void addTrigger(PgTrigger pgTrigger) {
        this.triggers.add(pgTrigger);
    }

    public void addRule(PgRule pgRule) {
        this.rules.add(pgRule);
    }

    public abstract String getRelationKind();

    public String getDropSQL() {
        return "DROP " + this.getRelationKind() + " " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public boolean containsColumn(String string) {
        for (PgColumn pgColumn : this.columns) {
            if (!pgColumn.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public PgInheritedColumn getInheritedColumn(String string) {
        return null;
    }

    public boolean containsInheritedColumn(String string) {
        return false;
    }

    public boolean containsIndex(String string) {
        for (PgIndex pgIndex : this.indexes) {
            if (!pgIndex.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<PgRelationPrivilege> getPrivileges() {
        return Collections.unmodifiableList(this.privileges);
    }

    public String getOwnerTo() {
        return this.ownerTo;
    }

    public void setOwnerTo(String string) {
        this.ownerTo = string;
    }

    public void addPrivilege(PgRelationPrivilege pgRelationPrivilege) {
        this.privileges.add(pgRelationPrivilege);
    }

    public PgRelationPrivilege getPrivilege(String string) {
        for (PgRelationPrivilege pgRelationPrivilege : this.privileges) {
            if (!pgRelationPrivilege.getRoleName().equals(string)) continue;
            return pgRelationPrivilege;
        }
        return null;
    }
}

