/**
 * Dynamic array of pointers to elements.
 * 
 * FIXME: missing getter with index range check.
 * 
 * FIXME: missing list manipulation functions: setter, remove, sorting.
 * Probably not needed by this program.
 * 
 * FIXME: BUG: repeated element causes abort releasing memory for "double free".
 * 
 * @file
 */

#ifndef _LIST_H_
#define _LIST_H_

#ifdef list_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef struct {
	int size;
	int n;
	char **arr;
} list_Type;

/**
 * Returns a new empty list.
 * @return New empty list. Can be released with memory_dispose(), which also
 * releases each element.
 */
EXTERN list_Type * list_new(void);

/**
 * Appends an element to the list.
 * @param l Subject list.
 * @param s Element to append, which is internally duplicated in memory. Can be
 * NULL.
 */
EXTERN void list_add_elem(list_Type *l, char *s);

/**
 * Appends all the elements of another list.
 * @param l Subject list.
 * @param q Elements to append.
 */
EXTERN void list_add_list(list_Type *l, list_Type *q);

#undef EXTERN
#endif
