% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{layout_json}
\alias{layout_json}
\title{Generate log layout function rendering JSON}
\usage{
layout_json(fields = default_fields())
}
\arguments{
\item{fields}{character vector of field names to be included in the
JSON}
}
\value{
character vector
}
\description{
Generate log layout function rendering JSON
}
\note{
This functionality depends on the \pkg{jsonlite} package.
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
log_layout(layout_json())
log_info(42)
log_info("ok {1:3} + {1:3} = {2*(1:3)}")
\dontshow{logger:::namespaces_set(old)}
}
\seealso{
Other log_layouts: 
\code{\link{get_logger_meta_variables}()},
\code{\link{layout_blank}()},
\code{\link{layout_glue}()},
\code{\link{layout_glue_colors}()},
\code{\link{layout_glue_generator}()},
\code{\link{layout_json_parser}()},
\code{\link{layout_logging}()},
\code{\link{layout_simple}()}
}
\concept{log_layouts}
