/*
 *  prune.c -- prune Usable
 *
 */

#ifdef PRUNE

#include "header.h"

static int intcompare(i,j)
     int *i, *j;
{
  return(*i - *j);
}

/*************
 *
 *   input_clauses_in_list()
 *
 *************/

int input_clauses_in_list(lst)
     struct list *lst;
{
  int i = 0;
  struct clause *c = lst->first_cl;

  while (c != NULL && c->id <= Max_input_id) {
    c = c->next_cl;
    i++;
  }
  return i;
}  /* input_clauses_in_list */

/*************
 *
 *   middle_clause()
 *
 *************/

struct clause *middle_clause(l, size)
     struct list *l;
     int size;
{
  int i, mid;
  struct clause *c;
  mid = size / 2;
  c = l->first_cl;

  for (i = 1; i < mid && c != NULL; i++)
    c = c->next_cl;

  return c;
  
}  /* middle_clause */

/*************
 *
 *   activity()
 *
 *************/

void activity(c, t)
     struct clause *c;
     int t;
{
  /* For each clause with id > t, from c to the end of the list,
   * go through its parent list.  For each parent in Usable, 
   * increment the activity counter of that parent.
   */

  struct clause *d;

  for (d = c; d != NULL; d = d->next_cl) {
    if (d->id >= t) {
      struct int_ptr *ip;
      for (ip = d->parents; ip; ip = ip->next) {
	if (ip->i <= LIST_RULE) {
	  /* LIST_RULE is a large negative number. */
	  /* If ip->i is less than LIST_RULE, then a list follows. */
	  int i;
	  int j = LIST_RULE - ip->i;
	  for (i = 1; i <= j; i++) {
	    ip = ip->next;
	  }
	}
	else if (ip->i < 0)
	  ; /* do nothing */
	else {
	  /* We have the clause id of a parent. */
	  struct clause *p = cl_find(ip->i);
	  if (p == NULL) {
	    abend("activity, clause not found");
	  }
	  else {
	    if (p->container == Usable) {
	      p->activity++;
	    }
	  }
	}
      }
    }
  }
}  /* activity */

/*************
 *
 *   p_activity()
 *
 *************/

void p_activity(l)
     struct list *l;
{
  struct clause *c;

  printf("\nActivity for list %s.\n", l->name);
  printf("activ  time  ID\n");
  for (c = l->first_cl; c != NULL; c = c->next_cl) {
    printf("%6d %6d ", c->activity, c->time_stamp);
    p_clause(c);
  }
  printf("\nEnd of list.\n\n");
}  /* p_activity */

/*************
 *
 *   possible_prune()
 *
 *************/

void possible_prune()
{
  if (Parms[MAX_USABLE_PRUNE].val != -1) {

    int input_usable = input_clauses_in_list(Usable);

    if (Stats[USABLE_SIZE] - input_usable > Parms[MAX_USABLE_PRUNE].val) {

      /* prune Usable list */
      struct clause *c, *mid, *first_gen_usable;
      int i, n, m, *a;

      for (i = 0, c = Usable->first_cl; i < input_usable; i++)
	c = c->next_cl;

      first_gen_usable = c;  /* First noninput usable clause */

      /* Reset activity fields to 0 and get middle clause. */
      for (i = 1, c = first_gen_usable; c != NULL; c = c->next_cl, i++) {
	c->activity = 0;
	if (i == (Stats[USABLE_SIZE] - input_usable) / 2) {
	  mid = c;
	  n = i;  /* size of the first half of gen usable, including mid. */
	}
      }
      
      /* Assign activity levels to Usable clauses. */
      activity(mid->next_cl, mid->time_stamp);
      activity(Sos->first_cl, mid->time_stamp);

      p_activity(Usable);

      /* Allocate an array of ints. */
      a = (int *) calloc((unsigned) n, (unsigned) sizeof(int));

      /* Copy activity counts to array. */
      for (c = first_gen_usable, i = 0; i < n; c = c->next_cl, i++)
	a[i] = c->activity;

      printf("\nActivity array:\n");
      for (i = 0; i < n; i++)
	printf(" %d", a[i]);
      printf("\n\n");

      qsort(a, n, sizeof(int), intcompare);

      printf("\nSorted array:\n");
      for (i = 0; i < n; i++)
	printf(" %d", a[i]);
      printf("\n\n");
      fflush(stdout);

      /* Set m to the cutoff value. */

      m = a[n/10];

      /* Delete, from oldest half of Usable, all clauses with activity
       * count <= m.
       */

      c = first_gen_usable;
      for (i = 0; i < n; i++) {
	if (c->activity <= m) {
	  struct clause *e;
	  printf("Pruning clause (activity=%d) ", c->activity);  p_clause(c);
	  e = c;
	  c = c->next_cl;
	  un_index_lits_all(e);
	  un_index_lits_clash(e);
	  rem_from_list(e);
	  hide_clause(e);
	}
	else
	  c = c->next_cl;
      }
      free(a);
    }
  }
}  /* possible_prune */

#endif
