/*
 * (C) Finite State Machine Labs Inc. 2000 business@fsmlabs.com
 *
 * Released under the terms of GPL 2.
 * Open RTLinux makes use of a patented process described in
 * US Patent 5,995,745. Use of this process is governed
 * by the Open RTLinux Patent License which can be obtained from
 * www.fsmlabs.com/PATENT or by sending email to
 * licensequestions@fsmlabs.com
 */

#include <rtl_sync.h>
#include <rtl.h>
#include <time.h>
#include <pthread.h>

#include <rtl_debug.h>

pthread_t thread = 0;

void *start_routine(void *arg)
{
	int *p;
	struct sched_param my_sparam;

	my_sparam.sched_priority = 1;

	rtl_printf("pthread_self() %016lx\n", pthread_self());

	pthread_setschedparam(pthread_self(), SCHED_FIFO, &my_sparam);
	pthread_make_periodic_np(pthread_self(),
				 clock_gethrtime(CLOCK_REALTIME),
				 NSECS_PER_SEC / 4);
	pthread_wait_np();
	pthread_wait_np();
	pthread_wait_np();
	pthread_wait_np();
	pthread_wait_np();
	pthread_wait_np();

	p = 0;
	*p = 1;

	return p;
}

int init_module(void)
{
	return pthread_create(&thread, NULL, start_routine, (void *) 1);
}

void cleanup_module(void)
{
	pthread_delete_np(thread);
}
