/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPMessages.h

	Contains:	API for getting text messages displayed by the server, or
				sent over the network. This prevents any hard-coded text from
				getting in the server.
	
	$Log: RTSPMessages.h,v $
	Revision 1.2  1999/02/19 23:08:29  ds
	Created
	
	
*/

#ifndef __RTSPMESSAGES_H__
#define __RTSPMESSAGES_H__

#include "StrPtrLen.h"


class RTSPMessages
{
	public:
		typedef UInt32 Message;

		enum
		{		
			kNoMessage = 0,			//All are of type "Message"
			kNoURLInRequest = 1,
			kBadRTSPMethod = 2,
			kNoRTSPVersion = 3,
			kNoRTSPInURL = 4,
			kURLTooLong = 5,
			kURLInBadFormat = 6,
			kNoColonAfterHeader = 7,
			kNoEOLAfterHeader = 8,
			kNoRTPModuleAvailable = 9,
			kNoClientPortInTransport = 10,
			kRTPPortMustBeEven = 11,
			kRTCPPortMustBeOneBigger = 12,
			kNoSessionID = 13,
			kExpectedDigitFilename = 14,
			kNoCacheFile = 15,
			kNoCacheFileHeader = 16,
			kNoSDPFileFound = 17,
			kCouldntListen = 18,
			kRefusingConnections = 19,
			kTooManyClients = 20,
			kTooMuchThruput = 21,
			kOutOfPorts = 22,
			kNoUDPSockets = 23,
			kCouldntOpenLog = 24,
			kCantBindReflectorSocket = 25,
			kCantJoinMulticastGroup = 26,
			kNoReflectorStream = 27,
			kCantAllocateMachPort = 28,
			kCantRegisterMachPort = 29,
			kServerControlFatalErr = 30,
			kSessionIDRequired = 31,
			kRequestTooLong = 32,
			kNotConfiguredForIP = 33,
			kDefaultRTSPAddrUnavail = 34,
			kBadQTFile = 35,
			kTrackDoesntExist = 36,
			kSeekToNonexistentTime = 37,
			kCouldntFindRemoteStatus = 38,
			kCouldntListenWarning = 39,
			kFileIsNotHinted = 40,
			kIllegalMessage = 41
		};
	
		RTSPMessages(){}
		~RTSPMessages(){}
		
		//gets a message. This always returns something. If your constant
		//is out of range, this returns kNoMessage
		StrPtrLen*		GetMessage(Message inMessage);

	private:

		//object currently just implemented as a static array of strings
		static StrPtrLen sMessages[];
};
#endif // __RTSPMESSAGES_H__
