/*********************************************
**********************************************
This file has the "ui" functions that read input
and send messages etc.

This software is provided AS IS to be used in
whatever way you see fit and is placed under the
GPL


Used/Changed for zICQ by Zack Allison, June 1998

Author : Matthew Smith April 23, 1998
Contributors : Nicolas Sahlqvist April 27, 1998
               Michael Ivey May 4, 1998
               Ulf Hedlund -- Windows Support
               Michael Holzt May 5, 1998
Changes :
**********************************************
**********************************************/

#include "zicq.h"
#include "datatype.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef _WIN32
  #include <winsock2.h>
#else
  #include <unistd.h>
  #include <netinet/in.h>
  #include <sys/types.h>
  #include <sys/stat.h>
  #include <sys/time.h>
  #include <sys/socket.h>
  #include <arpa/inet.h>
  #include <netdb.h>
#endif
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
//#include <strstream.h>

static DWORD last_uin=0; // No one's messaged us yet.
static DWORD multi_uin;
static void Show_Status( void );
int status;

#define UIN_DELIMS ":|/ " /* add space if you don't want your nick names to have spaces */
#define END_MSG_STR "."
#define CANCEL_MSG_STR "#"
#define W_SEPERATOR MESSCOL "=============" NOCOL "\n"

BOOL Do_Multiline( SOK_T sok, char *buf ) // run when we got to "multiline mode"
{
   static int offset=0;
   static char msg[2024];
   FD_T fdtmp;

wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"\n\nNow in Multi-Line mode to "); // Tell the user who they're
           wcolor_set(statz,4,NULL);			    // talking to
           lw_wprintw(statz,"%s ",Get_Nick(multi_uin));
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"(");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%ld",multi_uin);
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,")");
           wcolor_set(statz,1,NULL);

   wrefresh(statz);
  
   msg[ offset ] = 0;
   if ( ! strcmp( buf, END_MSG_STR ) )
   {
	char hbuffer[2024];
	time_t htimeval;

      icq_sendmsg( sok, multi_uin, msg );
      wcolor_set(mainw,1,NULL);
      lw_wprintw(mainw,"To: ");
      wcolor_set(mainw,4,NULL);
      lw_wprintw(mainw,"%s",Get_Nick(multi_uin));
      wcolor_set(mainw,1,NULL);
      rus_conv ("wk",msg);
	// Farquin tmp files due to lw_wprintw limitations
	// Dumps it to a file, then re-reads it
     if(( fdtmp = fopen(".zicqtmp", "w") ) == (FILE *) NULL ){
           lw_wprintw(mainw, "ERROR: Can't make tmp files.\n",
                           ".zicqtmp");
          goto zdone3; // I hate gotos
     }
   fprintf(fdtmp, "\n%s\n",line_wrap(mainw,&msg,0));
   fclose(fdtmp);


      fdtmp = open ( ".zicqtmp", O_RDONLY );
           if (fdtmp == -1) {
                lw_wprintw(mainw,"ERROR: Can't read tmp files.\n");
                goto zdone3;
           }
 //       lw_wprintw(mainw,"\n");
        for ( ; ! M_fdnreadln( fdtmp, hbuffer, sizeof( hbuffer ) ); ) {
                lw_wprintw(mainw,"%s\n",hbuffer);
           }
      close(fdtmp);
      remove( ".zicqtmp" );
      //wprintw(mainw,"\n%s\n",data);
      wrefresh(mainw);
    zdone3:
   

      last_uin = multi_uin;
      offset = 0;
      return FALSE;
   }
   else if ( ! strcmp( buf, CANCEL_MSG_STR ) )
   {
      lw_wprintw(mainw, "Message canceled!\n" );
      last_uin = multi_uin;
      offset = 0;
      return FALSE;
   }
   else
   {
      if ( offset + strlen( buf ) < 2024 )
      {
         strcat( msg, buf );
         strcat( msg, "\r\n" );
         offset += strlen( buf ) + 2;
         return TRUE;
      }
      else
      { // Never seen this executed.
         lw_wprintw(mainw, "Message sent before last line buffer is full\n" );
         icq_sendmsg( sok, multi_uin, msg );
         last_uin = multi_uin;
         offset = 0;
         return FALSE;
      }
   }
}

BOOL Do_Multiline_All( SOK_T sok, char *buf ) // Sending a long message
{					     // To everyone on the list
   static int offset=0;
   static char msg[2024];
   int i;
   
   msg[ offset ] = 0;
   if ( ! strcmp( buf, END_MSG_STR ) )
   {
      for ( i=0; i < Num_Contacts; i++ )
         icq_sendmsg( sok, Contacts[i].uin, msg );
      lw_wprintw(mainw,"To: %s\n%s\n","EVERYONE",msg);
      offset = 0;
      return FALSE;
   }
   else if ( ! strcmp( buf, CANCEL_MSG_STR ) )
   {
      lw_wprintw(mainw, "Message canceled!\n" );
      offset = 0;
      return FALSE;
   }
   else
   {
      if ( offset + strlen( buf ) < 2024 )
      {
         strcat( msg, buf );
         strcat( msg, "\r\n" );
         offset += strlen( buf ) + 2;
         return TRUE;
      }
      else
      {
         lw_wprintw(mainw, "Message sent before last line buffer is full\n" );
         for ( i=0; i < Num_Contacts; i++ )
            icq_sendmsg( sok, Contacts[i].uin, msg );
         offset = 0;
         return FALSE;
      }
   }
}

/******************************************************
Read a line of input and processes it.
*******************************************************/
void Get_Input( SOK_T sok )
{
   char buf[2024]; /* This is hopefully enough. Added more, ZA */
   char *cmd; // The command
   char *arg1; // First argument (eventually)
  // static status = 0;
   DWORD uin;
   noecho(); // Show 'em what they're typing.  ncurses.h
   raw(); // don't grab key stroke. ncurses.h
   memset( buf, 0, 2024 ); // allocate memory
   wcolor_set(userin,2,NULL);
   lw_wprintw(userin,"\n\n\n\nzICQ> "); //prompt, shown when a key is pressed

   wcolor_set(userin,1,NULL);
   wrefresh(userin);
   Show_Quick_Status();
   //wgetnstr(userin,&buf,1023); // Gets the string, 1023 bytes.
   //strncpy(&buf,readline (""),1023);
   strcpy(&buf,zgetline(1023));
   wcolor_set(userin,2,NULL);
   lw_wprintw(userin,"\n\n\n\nzICQ> "); //prompt, shown when a key is pressed

   wcolor_set(userin,1,NULL);
   wrefresh(userin);
   buf[1023]=0; /* be safe */
   if ( status == 1 )
   {
      if ( ! Do_Multiline( sok, buf ) ) // Are we doing multiline?
      {
         status = 2;
      } else {
	   wcolor_set(statz,1,NULL);
	   lw_wprintw(statz,"\n\nNow in Multi-Line mode to ");
	   wcolor_set(statz,4,NULL);
	   lw_wprintw(statz,"%s ",Get_Nick(multi_uin));
	   wcolor_set(statz,1,NULL);
	   lw_wprintw(statz,"(");
	   wcolor_set(statz,4,NULL);
	   lw_wprintw(statz,"%ld",multi_uin);
	   wcolor_set(statz,1,NULL);
	   lw_wprintw(statz,")");
	   wcolor_set(statz,1,NULL);
	   fflush(stdout);
   	}
   }
   else if ( status == 3 )
   {
      if ( ! Do_Multiline_All( sok, buf ) ) // Multi-to Everyone?
      {
         status = 2;
      } else {
	   printf ( "msg all> ");
	   fflush(stdout);
   	}
   }
   else
   {
      if ( buf[0] != 0 )
      {
         cmd = strtok( buf, " \n\t" );
         if ( cmd == NULL )
            goto done;  /* ARRRGGGGHHHH!!!! I hate gotos */
         if ( ( ! strcasecmp( cmd , "quit" ) ) ||
              ( ! strcasecmp( cmd , "/quit" ) ) )
         {
            Quit = TRUE;
         }
         else if ( ! strcasecmp( cmd, quit_cmd ) )
         {
            Quit = TRUE;
         }
         else if ( ! strcasecmp( cmd, change_cmd ) )
         {
            arg1 = strtok( NULL, " \n\r" );
            if ( arg1 == NULL )
            {
               lw_wprintw(mainw,  CLIENTCOL "Status modes: \n" );
               lw_wprintw(mainw, "Status online         %d\n", STATUS_ONLINE );
               lw_wprintw(mainw, "Status Away           %d\n", STATUS_AWAY );
               lw_wprintw(mainw, "Status Do not Disturb %d\n", STATUS_DND );
               lw_wprintw(mainw, "Status Not Available  %d\n", STATUS_NA );
               lw_wprintw(mainw, "Status Free for Chat  %d\n", STATUS_FREE_CHAT );
               lw_wprintw(mainw, "Status Occupied       %d\n", STATUS_OCCUPIED );
               lw_wprintw(mainw, "Status Not Available  %d\n", STATUS_NA );
               lw_wprintw(mainw, "Status Invisible      %d\n", STATUS_INVISIBLE );
               lw_wprintw(mainw, NOCOL "\n" );
            }
            else
            {
               icq_change_status( sok, atoi( arg1 ) );
	       waddstr(statz,"\nCurrent Stat: "); 
/*		wrefresh(statz);
              Print_Status(statz, Current_Status );
               lw_wprintw(mainw, "\n" );
*/
		Show_Quick_Status();
            }
         }
              else if ( ! strcasecmp( cmd, "sound" ) ) /* Toggle Sound */
              {
                Dosound = (Dosound == FALSE);
                lw_wprintw(mainw,"Sound now set to %s\n",Dosound ? "On" : "Off" );
              }
	      else if ( ! strcasecmp( cmd, "beep" ) ) /* Toggle BEEP */
	      {
		Dobeep = (Dobeep == FALSE);
		lw_wprintw(mainw,"Beep now set to %s\n",Dobeep ? "On" : "Off" );
	      }
	      else if ( ! strcasecmp( cmd, online_cmd ) ) /* online command */
	      {
	          icq_change_status( sok, STATUS_ONLINE );
             	  //Print_Status(statz, Current_Status );
		  Show_Quick_Status();
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, away_cmd ) ) /* away command */
	      {
	          icq_change_status( sok, STATUS_AWAY );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, na_cmd ) ) /* Not Available command */
	      {
	          icq_change_status( sok, STATUS_NA );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, occ_cmd ) ) /* Occupied command */
	      {
	          icq_change_status( sok, STATUS_OCCUPIED );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, dnd_cmd ) ) /* Do not Disturb  command */
	      {
	          icq_change_status( sok, STATUS_DND );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, ffc_cmd ) ) /* Free For Chat command */
	      {
	          icq_change_status( sok, STATUS_FREE_CHAT );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, inv_cmd ) ) /* Invisible command */
	      {
	          icq_change_status( sok, STATUS_INVISIBLE );
                  Print_Status(statz, Current_Status );
                  //lw_wprintw(mainw, "\n" );
	      }
	      else if ( ! strcasecmp( cmd, search_cmd ) ) // Search based on email
	      {
                  arg1 = strtok( NULL, "\n" );
                  if ( arg1 == NULL )
             {
                  lw_wprintw(mainw,"Must enter email address.\n");
             }
             else
             {
   	          start_search( sok, arg1, "", "", "" );
             }
	      }
         else if ( ! strcasecmp( cmd, status_cmd ) ) // Full status.
         {
            Show_Status();
         }
         else if ( ! strcasecmp( cmd, list_cmd ) ) // Quick Status, list box
         {
            Show_Quick_Status();
         }
         else if ( ! strcasecmp( cmd, "msga" ) ) // Message everyone!
         {
            status = 3;
            lw_wprintw(mainw, "msg all> " );
            fflush(stdout);
         }
         else if ( ! strcasecmp( cmd, reply_cmd ) ) /* reply command */
         {
            if ( last_recv_uin == 0 )
            {
               lw_wprintw(mainw, "Must receive a message first\n" );
               goto done;
            }
            arg1 = strtok( NULL, "" );
            last_uin = last_recv_uin;
            if ( arg1 != NULL )
            {
               icq_sendmsg( sok, last_recv_uin, arg1 );
		wcolor_set(mainw,1,NULL);
		wprintw(mainw,"To ");
		wcolor_set(mainw,4,NULL);
		wprintw(mainw,"%s",Get_Nick(last_recv_uin));
		wcolor_set(mainw,1,NULL);
		lw_wprintw(mainw,": %s\n",arg1);
            }
            else
            {
	       wcolor_set(statz,1,NULL);
               lw_wprintw(statz,"\n\nNow in Multi-Line mode to ");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%s ",Get_Nick(last_recv_uin));
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"(");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%ld",last_recv_uin);
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,")");
           wcolor_set(statz,1,NULL);

               status = 1;
            }
         }
         else if ( ! strcasecmp( cmd, "resize") ) /* resize: Works now.    */
					  /* use when you change yer screen*/
					  /* size. (Xterm,etc) */
         {
		resize();
		wprintw(mainw,"Resized to %ix%i\n",LINES,COLS);
		if (has_colors()) {
			wcolor_set(mainw,2,NULL);
			wprintw(mainw,"Term supports Color.\n");
			wcolor_set(mainw,1,NULL);
		} else {
			wprintw(mainw,"Term does NOT support color :(\n");
		}
		Show_Quick_Status();
	 }
	 else if ( ! strcasecmp( cmd, "url" ) ) /* send a url. */
	 {
	 char* desc;
	 char* data;
	 char* arg2;
         DWORD uuin;
	 int err=0;
	 arg1 = strtok (NULL, ""); // Gets the rest of the command, and parses it
	 if ( arg1 != NULL ) {
	   arg2 = strsep( &arg1, " ");
	   if ((arg2 != NULL ) && (arg1 !=NULL)) {
	    if (nick2uin( arg2 ) != -1) {
   	     data = strsep( &arg1, " ");   
             if (( data != NULL ) && (arg1 !=NULL)) {
	      desc = arg1;
	      uuin = (DWORD) nick2uin( arg2 );
	      icq_sendurl(sok, (DWORD) uuin, desc,data);
	      wcolor_set(mainw,1,NULL);
	      lw_wprintw(mainw,"Sent URL to ");
	      wcolor_set(mainw,4,NULL);
	      lw_wprintw(mainw,"%s",Get_Nick(uuin));
	      wcolor_set(mainw,1,NULL);
	      lw_wprintw(mainw,"(");
	      wcolor_set(mainw,4,NULL);
	      lw_wprintw(mainw,"%ld",uuin);
	      wcolor_set(mainw,1,NULL);
	      lw_wprintw(mainw,")\n       URL: ");
	      lw_wprintw(mainw,"%s\n",data);
	      lw_wprintw(mainw,"Decription: ");
	      lw_wprintw(mainw,"%s\n",desc);
	      goto zdone5; // I HATE GOTOS!!!!
	     }
	   }
	  err = 1;
	  }
         }
	 if (err == 1) { // did they screw up?
		wprintw(mainw,"No such user: %s\n",arg2);
	 } else {
	 	wprintw(mainw,"Too few arguments: url <nick> <url> <description>\n");
	 	zdone5:
	 }
	}
       else if ( ! strcasecmp( cmd, "spoof") ) /* my spoof command: launches external program.*/
	 {					/* if you can't figure this out, you don't need */
	 char* arg2;			       /* to use it. */
	 char* spoofuin;
	 char* mess;
	 char cmd2[300];
	 DWORD theip;
	 DWORD theiruin;
	 DWORD theport;

	 arg1 = strtok( NULL, "" );
	 arg2 = strsep( &arg1, " ");
	 spoofuin = strsep ( &arg1, " ");
	 mess = arg1;

	 theiruin = nick2uin ( arg2 );
	 theip = Get_IP( theiruin );
	 theport = Get_Port( theiruin );
	 sprintf( &cmd2, "icqspoof %u.%u.%u.%u %s \"%s\" %ld %ld > /dev/null &",(BYTE)(theip>>24),(BYTE) (theip>>16),(BYTE)(theip>>8),(BYTE) theip,spoofuin,mess,theport,theport);
	 system(&cmd2);
	 sprintf( &cmd2, "Spoofed to: %ld from %s said: %s\n",theiruin,spoofuin,mess);
	 lw_wprintw(mainw,&cmd2);
	 
	 }

         else if ( ! strcasecmp( cmd, again_cmd ) ) /* again command */
						    /* msg to same person, AGAIN */
         {
            if ( last_uin == 0 )
            {
               lw_wprintw(mainw, "Must write one message first\n" );
               goto done;
            }
            arg1 = strtok( NULL, "" );
            if ( arg1 != NULL )
            {
               icq_sendmsg( sok, last_uin, arg1 );
	       wcolor_set(mainw,1,NULL);
               lw_wprintw(mainw,"To ");
	       wcolor_set(mainw,4,NULL);
	       lw_wprintw(mainw,"%s",Get_Nick(last_uin));
	       wcolor_set(mainw,1,NULL);
	       lw_wprintw(mainw,": %s\n",arg1);
            }
            else
            { 
               status = 1;
wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"\n\nNow in Multi-Line mode to ");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%s ",Get_Nick(last_uin));
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"(");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%ld",last_uin);
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,")");
           wcolor_set(statz,1,NULL);

               fflush(stdout);
            }
         }
         else if ( ! strcasecmp( cmd, "clear")) // Clears the mainwindow
   	   {
      	 	clrscr();
      		goto done;
      	}
         else if ( ! strcasecmp( cmd, info_cmd ) ) // Get info from the server
         {
            arg1 = strtok( NULL, "" );
            if ( arg1 == NULL )
            {
               lw_wprintw(mainw, "Need uin to get info on\n" );
               goto done; /* sorry */
            }
            uin = nick2uin( arg1 );
            if ( -1 == uin )
            {
               lw_wprintw(mainw, "%s not recognized as a nick name\n", arg1 );
               goto done;
            }
            lw_wprintw(mainw, "%s's IP address is ", arg1 );
            Print_IP( uin );
            lw_wprintw(mainw, "\tThe port is %d\n",(WORD) Get_Port( uin ) );
            send_info_req( sok, uin );
         }
         else if ( ! strcasecmp( cmd, add_cmd ) ) //add a new user to yer list
         {
            arg1 = strtok( NULL, " \t" );
            if ( arg1 != NULL )
            {
               uin = atoi( arg1 );
               arg1 = strtok( NULL, "" );
               if ( arg1 != NULL )
               {
                  Add_User( sok, uin, arg1 );
                  lw_wprintw(mainw, "%s added.\n", arg1 );
               }
            }
            else
            {
               lw_wprintw(mainw, SERVCOL "Must specify a nick name" NOCOL "\n" );
            }
         }
	 else if ( ! strcasecmp( cmd, "hist" ) ) // Show history [of user]
	 {
	     FD_T   *fdhist;
   	     char    hbuffer[2024];
  	     time_t  htimeval;
  	     char *hpath;
  	     char hbuf[2024];
	     char htmp[20];
	     cmd = strtok( NULL, "" );

	   if ( ! Logging )
	      return ;

#ifdef _WIN32
   	hpath = ".\\";
#endif

#ifdef UNIX
   	hpath = getenv( "HOME" );
#endif

#ifdef __amigaos__
   	hpath = "PROGDIR:";
#endif
	   strcpy( hbuffer, hpath );
	   if ( cmd == NULL ) {
		strcat(hbuffer,"/.zicq/zicq_log");
	   } else {
		if (nick2uin(cmd) == -1) {
			wprintw(mainw,"Not a valid name: %s\n",cmd);
			goto zdone;
		}
		sprintf(&htmp,"/.zicq/.zicq-%ld",nick2uin(cmd));
		strcat(hbuffer,&htmp);
	   }

	   fdhist = open ( hbuffer, O_RDONLY );
           if (fdhist == -1) {
		wprintw(mainw,"No history found or could not be read.\n");
		goto zdone;
	   }
	   lw_wprintw(mainw,"=== History from %s ===\n",hbuffer);
	   for ( ; ! M_fdnreadln( fdhist, hbuf, sizeof( hbuf ) ); ) {
		wprintw(mainw,"%s\n",hbuf);
	   }
	   lw_wprintw(mainw,"=== End of History ===\n");
	   close(fdhist);
	   zdone:
	 }
	 else if ( ! strcasecmp( cmd, "iinfo" ) )
	 {
	    arg1 = strtok( NULL, "" );
            if ( arg1 == NULL )
            {
               lw_wprintw(mainw, "Need uin to get info on\n" );
               goto done; /* sorry */
            }
            uin = nick2uin( arg1 );
            if ( -1 == uin )
            {
               lw_wprintw(mainw, "%s not recognized as a nick name\n", arg1 );
               goto done;
            }
	  Print_UIN_Name( uin );
	  lw_wprintw (mainw, "'s (");
	  lw_wprintw (mainw, "%ld", uin );
	  lw_wprintw (mainw, ") IP address is " );
	  Print_IP( uin );
	  lw_wprintw (mainw, "  The port is %d\n", (WORD) Get_Port( uin ) );
	 }
         else if ( ! strcasecmp( cmd, "rinfo" ) )
         {
	    arg1 = strtok( NULL, "" );
            if ( arg1 == NULL )
            {
               lw_wprintw(mainw, "Need uin to get info on\n" );
               goto done; /* sorry */
            }
            uin = nick2uin( arg1 );
            if ( -1 == uin )
            {
               lw_wprintw(mainw, "%s not recognized as a nick name\n", arg1 );
               goto done;
            }

            Print_UIN_Name( uin );
            lw_wprintw(mainw, "'s IP address is " );
            Print_IP( uin );
            lw_wprintw(mainw, "\tThe port is %d\n",(WORD) Get_Port( uin ) );
            send_info_req( sok, uin );
         }
         else if ( ( ! strcasecmp( cmd, "/help" ) ) || 
                   ( ! strcasecmp( cmd, "help" ) ) ) // Ugly help command. TODO
         {
	 arg1 = strtok( NULL, "" );
             if ( arg1 == NULL )
             {
		 wcolor_set(mainw,2,NULL);
		 lw_wprintw(mainw,"Help\n A    ADD    AUTH    AUTO    AWAY    BEEP    CHANGE    CLEAR    DND    FFC    HIST    INFO    INV    MSG    MSGA    NA    OCC    ONLINE    QUIT    R    RESIZE    SEARCH    SOUND    URL\n\n");
		 wcolor_set(mainw,1,NULL);
	     } else {
		if ( ! strcasecmp( arg1, "A" ) ) {
			lw_wprintw(mainw,"A - Useage: a <message>\n");
			lw_wprintw(mainw,"Purpose: Sends a message to the same nick. Its short for again Multi-line mode works the same in this as in msg command.\n");
		} else if ( ! strcasecmp( arg1, "ADD") ) {
			lw_wprintw(mainw,"Add - Useage: Add uin Nick\n");
			lw_wprintw(mainw,"Purpose: Adds a person to your contact list with the designated nick.\n");
		} else if ( ! strcasecmp( arg1, "AUTH" ) ) {
			lw_wprintw(mainw,"Auth - Useage: auth [uin/nick]\n");
			lw_wprintw(mainw,"Purpose: If your account is set that users must request your authorization before adding you to their contact list, they will send you an authorization request. This command gives them your authorization.\n");
		} else if ( ! strcasecmp( arg1, "AUTO" ) ) {
			lw_wprintw(mainw,"Auto - Useage: Auto [on/off] <message>\n");
			lw_wprintw(mainw,"Purpose: Toggles your Auto reply, and sets your auto reply message.\n");
		} else if ( ! strcasecmp( arg1, "AWAY" ) ) {
			lw_wprintw(mainw,"Away - Useage: Away\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as Away. Same as \"change 1\"\n");
		} else if ( ! strcasecmp( arg1, "BEEP" ) ) {
			lw_wprintw(mainw,"Beep - Useage: Beep\n");
			lw_wprintw(mainw,"Purpose: Toggles beeps on or off. Beeps are triggered by messages and urls\n");
		} else if ( ! strcasecmp( arg1, "CHANGE" ) ) {
			lw_wprintw(mainw,"Change - Useage: change #      (change without any # lists possible numbers)\n");
			lw_wprintw(mainw,"Purpose: Allows you to change your \"status\". Eg: online, away, etc\n");
		} else if ( ! strcasecmp( arg1, "CLEAR" ) ) {
			lw_wprintw(mainw,"Clear - Useage: clear\n");
			lw_wprintw(mainw,"Purpose: clears the main window of all text.\n");
		} else if ( ! strcasecmp( arg1, "DND") ) {
			lw_wprintw(mainw,"Dnd - Useage: dnd\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as do not disturb. Same as \"change 19\"\n");
		} else if ( ! strcasecmp( arg1, "DND") ) {
			lw_wprintw(mainw,"Ffc - Useage: ffc\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as free for chat. Same as \"change 32\"\n");
		} else if ( ! strcasecmp( arg1, "HIST" ) ){
			lw_wprintw(mainw,"Hist - Useage: hist [uin/nick]\n");
			lw_wprintw(mainw,"Purpose: Shows a complete log of messages from the designated account.\n");
		} else if ( ! strcasecmp( arg1, "INFO" ) ){
			lw_wprintw(mainw,"Info - Useage: info [uin/nick]\n");
			lw_wprintw(mainw,"Purpose: Gets information on the desired uin, such as port, name, email. *note* you can only get the personal info the person submitted\n");
		} else if ( ! strcasecmp( arg1, "INV" ) ){
			lw_wprintw(mainw,"Inv - Useage: inv\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as invisible (other users wont see that you are online.) Same as \"change 256\"\n");
		} else if ( ! strcasecmp( arg1, "MSG" ) ) {
			lw_wprintw(mainw,"Msg - Useage: msg [uin/nick] <message>\n");
			lw_wprintw(mainw,"Purpose: Sends the desired uin a message. Also if you do not specify a message (Ex: msg 123456), you will enter multi-line mode for longer messages. Use a . on a single line to send the message.\n");
		} else if ( ! strcasecmp( arg1, "MSGA" ) ) {
			lw_wprintw(mainw,"Msga - Useage: msga <message>\n");
			lw_wprintw(mainw,"Purpose: Similar to the msg command, except that it sends a message to everyone in your contact list. Multi-line mode works the same as it does in Msg.\n");
		} else if ( ! strcasecmp( arg1, "NA" ) ) {
			lw_wprintw(mainw,"Na - Useage: na\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as not avaliable. Same as \"change 5\"\n");
		} else if ( ! strcasecmp( arg1, "OCC") ) {
			lw_wprintw(mainw,"Occ - Useage: occ\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as occupied. Same as \"change 17\"\n");
		} else if ( ! strcasecmp( arg1, "ONLINE") ) {
			lw_wprintw(mainw,"Online - Useage: online\n");
			lw_wprintw(mainw,"Purpose: Sets your server status as online. Same as \"change 0\"\n");
		} else if ( ! strcasecmp( arg1, "QUIT") ) {
			lw_wprintw(mainw,"Quit - Useage: quit, or just q\n");
			lw_wprintw(mainw,"Purpose: Logs you off the icq server, and exits zicq.");
		} else if ( ! strcasecmp( arg1, "R") ) {
			lw_wprintw(mainw,"R - Useage: r <message>\n");
			lw_wprintw(mainw,"Purpose: Replies with a message to the last nick that messaged you. Multi-line mode works the same as with all the other message commands.\n");
		} else if ( ! strcasecmp( arg1, "RESIZE" ) ) {
			lw_wprintw(mainw,"Resize - Useage: resize\n");
			lw_wprintw(mainw,"Purpose: Handy for xterms, if you mess up your window, will destroy then rebuild the window.\n");
		} else if ( ! strcasecmp( arg1, "SEARCH") ) {
			lw_wprintw(mainw,"Search - Useage: search user@host\n");
			lw_wprintw(mainw,"Purpose: finds users in the servers database with a matching email address. *note* if you just put in the user without a host you will see _all_ possible matches. Ex: search test\n");
		} else if ( ! strcasecmp( arg1, "SOUND") ) {
			lw_wprintw(mainw,"Sound - Useage: sound\n");
			lw_wprintw(mainw,"Purpose: toggles sounds on/off. Sounds are configurable in ~.zicqrc any player/file can be used as long as its setup in your environment. Sounds are triggered by messages, and notices.\n");
		} else if ( ! strcasecmp( arg1, "URL") ) {
			lw_wprintw(mainw,"Url - Useage: url [uin/nick] <url> <description>\n");
			lw_wprintw(mainw,"Purpose: Sends a url notice to the designated account with description.\n");
		} else if ( ! strcasecmp( arg1, "420") ) {
			lw_wprintw(mainw,"420 - Usage: Burn.  Inhale\n");
			lw_wprintw(mainw,"Purpose: Intoxication");
		} else {
#ifdef FUNNY_MSGs
			lw_wprintw(mainw,"%s - Usage: %s <credit card number> <pin>\n",arg1,arg1);
			lw_wprintw(mainw,"Purpose: Send me your credit card and pin. Thanks!\n");
#else
			lw_wprintw(mainw,"No help for: %s\n",arg1);
#endif
		}
	     }
	     wprintw(mainw,"\n");
   	    }
         else if ( ! strcasecmp( cmd, auth_cmd ) ) // Authorize a user
         {
             arg1 = strtok( NULL, "" );
             if ( arg1 == NULL )
             {
                lw_wprintw(mainw, "Need uin to send to\n" );
                goto done; /* sorry */
             }
             uin = nick2uin( arg1 );
             if ( -1 == uin )
             {
                lw_wprintw(mainw, "%s not recognized as a nick name\n", arg1 );
                goto done;
             }
	     lw_wprintw(mainw,"Sent Auth message to %ld\n",uin);
             icq_sendauthmsg( sok, uin );
         }
         else if ( ! strcasecmp( cmd, message_cmd ) ) /* send a message */
         {
            arg1 = strtok( NULL, UIN_DELIMS );
            if ( arg1 == NULL )
            {
               lw_wprintw(mainw, "Need uin to send to\n" );
               goto done; /* sorry */
            }
            uin = nick2uin( arg1 );
            if ( -1 == uin )
            {
               lw_wprintw(mainw, "%s not recognized as a nick name\n", arg1 );
               goto done;
            }
            arg1 = strtok( NULL, "" );
            last_uin = uin;
            if ( arg1 != NULL )
            {
               icq_sendmsg( sok, uin, arg1 );
	       wcolor_set(mainw,1,NULL);
	       lw_wprintw(mainw,"To ");
	       wcolor_set(mainw,4,NULL);
	       lw_wprintw(mainw,"%s",Get_Nick(uin));
   	       wcolor_set(mainw,1,NULL);
	       lw_wprintw(mainw,": %s\n",arg1);
            }
            else
            {
               status = 1;
wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"\n\nNow in Multi-Line mode to ");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%s ",Get_Nick(multi_uin));
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"(");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%ld",multi_uin);
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,")");
           wcolor_set(statz,1,NULL);
	       wrefresh(statz);
               fflush(stdout);
            }
         }
         else if ( ! strcasecmp( cmd, "auto" ) ) // Automatic replies
         {
            cmd = strtok( NULL, "" );
            if ( cmd == NULL )
            {
               lw_wprintw(mainw, "Automatic replies are %s\n", auto_resp ? "On" : "Off" );
               lw_wprintw(mainw, "The message is: \n%s\n", auto_rep_str );
               goto done;
            }
            if ( ! strcasecmp( cmd, "on" ) )
            {
               auto_resp = TRUE;
               lw_wprintw(mainw, "Automatic replies are on.\n" );
            }
            else if ( ! strcasecmp( cmd, "off" ) )
            {
               auto_resp = FALSE;
               lw_wprintw(mainw, "Automatic replies are off.\n" );
            }
            else
            {
               lw_wprintw(mainw, "Automatic reply set\n" );
               strcpy( auto_rep_str, cmd );
            }
         }
         else 
         {
            lw_wprintw(mainw, "Unknown command %s, type /help for help.\n", cmd );
         }
         done:  /* sorry I hate goto's also */
	     ;
      }
   }
   multi_uin = last_uin;
   if ( ( status != 1 ) && ( status != 3) )
   {
      if ( ! Quit )
         Prompt();
   }
}

static void Show_Status( void ) // Show lots of information
{
   int i;
   lw_wprintw(statz, "Your status is " );
   Print_Status(statz, Current_Status );
   lw_wprintw(statz,"\tLast: ");
   lw_wprintw(statz,"%s\t",Get_Nick(last_recv_uin));
   lw_wprintw(statz,"Again: ");
   lw_wprintw(statz,"%s",Get_Nick(last_uin));
   wrefresh(statz);
   lw_wprintw(mainw, "\n" );
   /*  First loop sorts thru all offline users */
   for ( i=0; i< Num_Contacts; i++ )
   {
      if ( ( S_DWORD )Contacts[ i ].uin > 0 )
      {
         if ( Contacts[ i ].status == STATUS_OFFLINE )
         {
	    wcolor_set(mainw,4,NULL);
            lw_wprintw(mainw, "%8ld", Contacts[ i ].uin ); 
	    wcolor_set(mainw,1,NULL);
	    lw_wprintw(mainw, " = ");
	    wcolor_set(mainw,4,NULL);
            lw_wprintw(mainw, "%-8s", Contacts[ i ].nick );
	    wcolor_set(mainw,1,NULL);
            Print_Status(mainw, Contacts[ i ].status );
	    wcolor_set(mainw,1,NULL);
            if ( -1L != Contacts[ i ].last_time )
            {
               if ( Contacts[ i ].status  == STATUS_OFFLINE )
                  lw_wprintw(mainw, ".  Last online at %s", ctime( (time_t *) &Contacts[ i ].last_time ) );
               else
                  lw_wprintw(mainw, ".  Online since %s", ctime( (time_t *) &Contacts[ i ].last_time )  );
            }
            else
            {
               lw_wprintw(mainw, " Last on-line unknown.\n" );
               /* if time is unknow they can't be logged on cause we */
               /* set the time at login */
            }
         }
      }
   }
   /* The second loop displays all the online users */
   for ( i=0; i< Num_Contacts; i++ )
   {
      if ( ( S_DWORD )Contacts[ i ].uin > 0 )
      {
         if ( Contacts[ i ].status != STATUS_OFFLINE )
         {
	    wcolor_set(mainw,4,NULL);
            lw_wprintw(mainw, "%8ld",Contacts[ i ].uin );
	    wcolor_set(mainw,1,NULL);
	    lw_wprintw(mainw, " = ");
	    wcolor_set(mainw,4,NULL);
            lw_wprintw(mainw, "%-8s", Contacts[ i ].nick );
            Print_Status(mainw, Contacts[ i ].status );
	    wcolor_set(mainw,1,NULL);
            if ( -1L != Contacts[ i ].last_time )
            {
               if ( Contacts[ i ].status  == STATUS_OFFLINE )
                  lw_wprintw(mainw, ". Last online at %s", ctime( (time_t *) &Contacts[ i ].last_time ) );
               else
                  lw_wprintw(mainw, ". Online since %s", ctime( (time_t *) &Contacts[ i ].last_time )  );
            }
            else
            {
               lw_wprintw(mainw, " Last on-line unknown.\n" );
               /* if time is unknow they can't be logged on cause we */
               /* set the time at login */
            }
         }
      }
   }
}

void Show_Quick_Status( void ) // reset your status line, and the buddy list
{
   int i;
   time_t htimeval;
        struct tm *thetime;

   if ( status == 1) {
	   wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"\n\nNow in Multi-Line mode to ");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%s ",Get_Nick(multi_uin));
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,"(");
           wcolor_set(statz,4,NULL);
           lw_wprintw(statz,"%ld",multi_uin);
           wcolor_set(statz,1,NULL);
           lw_wprintw(statz,")");
           wcolor_set(statz,1,NULL);
   
   wrefresh(statz);
   } else {  
   htimeval = time(0);
   wcolor_set(statz,1,NULL);
   lw_wprintw(statz, "\nStatus: " );
   Print_Status(statz, Current_Status );
   wcolor_set(statz,1,NULL);
   lw_wprintw(statz,"\tL: ");
   wcolor_set(statz,4,NULL);
   lw_wprintw(statz,"%s\t",Get_Nick(last_recv_uin));
   wcolor_set(statz,1,NULL);
   lw_wprintw(statz,"A: ");
   wcolor_set(statz,4,NULL);
   lw_wprintw(statz,"%s",Get_Nick(last_uin));
   wcolor_set(statz,1,NULL);
   lw_wprintw(statz, "\tAuto replies: %s     ", auto_resp ? "On" : "Off" );
   thetime=localtime(&htimeval);
   wclrtoeol(statz);
   mvwprintw(statz,0,COLS-7,"%.02d:%.02d",thetime->tm_hour,thetime->tm_min);
   wrefresh(statz);

   }
   lw_wprintw(blist, "\n\n" W_SEPERATOR );    lw_wprintw(blist, "%lu: ", UIN );

   for ( i=0; i< LINES; i++) {
       lw_wprintw(blist, "\n" );
   }
   /*  First loop sorts thru all offline users */
   /*  This comes first so that if there are many contacts */
   /*  The online ones will be less likely to scroll off the screen */
   mvwprintw(blist,0,0,"");
   wcolor_set(blist,5,NULL);
   lw_wprintw(blist, W_SEPERATOR );
   lw_wprintw(blist, "Users offline: \n" );
   wcolor_set(blist,1,NULL);
   for ( i=0; i< Num_Contacts; i++ )
   {
      if ( ( S_DWORD )Contacts[ i ].uin > 0 )
      {
         if ( Contacts[ i ].status == STATUS_OFFLINE )
         {
	    wcolor_set(blist,4,NULL);
            lw_wprintw(blist, CONTACTCOL "%-8s\n", Contacts[ i ].nick );
	    wcolor_set(blist,1,NULL);
            //Print_Status(blist, Contacts[ i ].status );
            //wprintw(blist, ")" NOCOL "\n" );
         }
      }
   }
   /* The second loop displays all the online users */
   wcolor_set(blist,5,NULL);
   lw_wprintw(blist, W_SEPERATOR );
   lw_wprintw(blist, "Users online: \n" );
   wcolor_set(blist,1,NULL);
   for ( i=0; i< Num_Contacts; i++ )
   {
      if ( ( S_DWORD )Contacts[ i ].uin > 0 )
      {
         if ( Contacts[ i ].status != STATUS_OFFLINE )
         {
	    wcolor_set(blist,4,NULL);
            lw_wprintw(blist, CONTACTCOL "%-8s", Contacts[ i ].nick ); 
	    wcolor_set(blist,1,NULL);
	    lw_wprintw(blist, MESSCOL "(");
            Print_Status(blist, Contacts[ i ].status );
            lw_wprintw(blist, ")" NOCOL "\n" );
         }
      }
   }
   wcolor_set(blist,5,NULL);
   lw_wprintw(blist, W_SEPERATOR );
}
