// @HEADER
// ***********************************************************************
// 
//    Thyra: Interfaces and Support for Abstract Numerical Algorithms
//                 Copyright (2004) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Michael A. Heroux (maherou@sandia.gov) 
// 
// ***********************************************************************
// @HEADER

#ifndef THYRA_OPERATOR_VECTOR_CLIENT_SUUPPORT_HPP
#define THYRA_OPERATOR_VECTOR_CLIENT_SUUPPORT_HPP

#include "Thyra_AssertOp.hpp"
#include "Thyra_DefaultAddedLinearOp.hpp"
#include "Thyra_DefaultBlockedLinearOp.hpp"
#include "Thyra_DefaultColumnwiseMultiVector.hpp"
#include "Thyra_DefaultDiagonalLinearOp.hpp"
#include "Thyra_DefaultIdentityLinearOp.hpp"
#include "Thyra_DefaultMultipliedLinearOp.hpp"
#include "Thyra_DefaultMultiVectorProductVector.hpp"
#include "Thyra_DefaultMultiVectorProductVectorSpace.hpp"
#include "Thyra_DefaultProductMultiVector.hpp"
#include "Thyra_DefaultProductVector.hpp"
#include "Thyra_DefaultProductVectorSpace.hpp"
#include "Thyra_DefaultScaledAdjointLinearOp.hpp"
#include "Thyra_DefaultZeroLinearOp.hpp"
#include "Thyra_describeLinearOp.hpp"
#include "Thyra_DetachedMultiVectorView.hpp"
#include "Thyra_DetachedVectorView.hpp"
#include "Thyra_LinearOpDefaultBase.hpp"
#include "Thyra_LinearOpTester.hpp"
#include "Thyra_ListedMultiVectorRandomizer.hpp"
#include "Thyra_MultiVectorAllocator.hpp"
#include "Thyra_MultiVectorDefaultBase.hpp"
#include "Thyra_MultiVectorStdOps.hpp"
#include "Thyra_MultiVectorStdOpsTester.hpp"
#include "Thyra_MultiVectorTester.hpp"
#include "Thyra_ParameterDrivenMultiVectorInput.hpp"
#include "Thyra_SingleRhsLinearOpBase.hpp"
#include "Thyra_SingleScalarLinearOpBase.hpp"
#include "Thyra_TesterBase.hpp"
#include "Thyra_TestingTools.cpp"
#include "Thyra_TestingTools.hpp"
#include "Thyra_TestSpecifier.hpp"
#include "Thyra_UniversalMultiVectorRandomizer.hpp"
#include "Thyra_VectorDefaultBase.hpp"
#include "Thyra_VectorOpTester.hpp"
#include "Thyra_VectorSpaceDefaultBase.hpp"
#include "Thyra_VectorSpaceImpl.hpp"
#include "Thyra_VectorSpaceTester.hpp"
#include "Thyra_VectorStdOps.hpp"
#include "Thyra_VectorStdOpsTester.hpp"
#include "Thyra_VectorTester.hpp"

#endif	// THYRA_OPERATOR_VECTOR_CLIENT_SUUPPORT_HPP
