%%
%% This is file `xepersian-thesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% xepersian.dtx  (with options: `xepersian-thesis.cls')
%% 
%%   __________________________________
%%   Copyright © 2008-2009 Vafa Khalighi
%% 
%%   License information appended.
%% 
%% 
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{xepersian-thesis}
              [2009/01/05 v0.1
 Persian thesis document class in XeLaTeX]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions
\LoadClass{report}
\def\university#1{\gdef\@university{#1}}
\def\department#1{\gdef\@department{#1}}
\def\degree#1{\gdef\@degree{#1}}
\def\thesisdate#1{\gdef\@thesisdate{#1}}
\def\supervisor#1{\gdef\@supervisor{#1}}
\def\city#1{\gdef\@city{#1}}

\def\latintitle#1{\gdef\@latintitle{#1}}
\def\latinauthor#1{\gdef\@latinauthor{#1}}
\def\latindegree#1{\gdef\@latindegree{#1}}
\def\latindepartment#1{\gdef\@latindepartment{#1}}
\def\latinthesisdate#1{\gdef\@latinthesisdate{#1}}
\def\latinsupervisor#1{\gdef\@latinsupervisor{#1}}
\def\latincity#1{\gdef\@latincity{#1}}
\def\latinuniversity#1{\gdef\@latinuniversity{#1}}

\def\maketitle{\begin{titlepage}
{\includegraphics{logo}}
\vskip 1.5cm
{\Huge\bfseries \@title}\par
\vskip 1cm
{\large%
  \by}\par
{\Large\bfseries \@author}\par
\vskip 5mm
{\large\bfseries\writtenfor
\par
\@degree}
\par
\vskip 1cm
{\large
  \undersupervision\par
\Large\bfseries \@supervisor}
\par
\vskip 1cm
{\large \@thesisdate}
\par
\vskip 1cm
{\large\bfseries\departmentof\space\@department}
\par
{\large\bfseries\universityof\space\@university \par\@city}
\vfill
\end{titlepage}%
}

\def\abstractpage{\newpage
\thispagestyle{empty}
\vskip 15mm
\begin{center}{\large{\bfseries \@title} \\}
\end{center}
\par
\begin{abstract}}
\def\endabstractpage{\end{abstract}
\newpage
}

\def\latinabstract{\newpage
\thispagestyle{empty}
\vskip 15mm
\begin{center}{\Large\bfseries \@latintitle \\[5mm]}
{\bfseries Abstract}
\end{center}
\vspace{5mm}}

\def\endlatinabstract{\newpage}

\def\acknowledgementpage{\newpage
\thispagestyle{empty}
\centerline{\Large \bfseries\acknowledgementname}
\vspace{1cm}
\par\noindent}
\def\endacknowledgementpage{\newpage}

\def\titlepage{\newpage\centering
  \thispagestyle{empty}
  \parindent 0pt \parskip 10pt plus 1fil minus 1fil
  \def\baselinestretch{1}\@normalsize\vbox to \vsize\bgroup\vbox to 9in\bgroup}
\def\endtitlepage{\par\kern 0pt\egroup\vss\egroup\newpage}

\def\signature#1#2{\par\noindent#1\dotfill\null\\*
  {\raggedright #2\par}}

\def\abstract{\subsection*{\abstractname}\small
\@normalsize}
\def\endabstract{\par}

\pagenumbering{harfi}
\let\ol@chapter\@chapter
\def\@chapter{%
  \ifnum\c@chapter=0 \pagenumbering{arabic}\setcounter{page}{1}\fi
  \ol@chapter}

\def\keywords#1{\par \vspace{5mm}
{\textbf{واژه‌های کلیدی:}} {\textit{ #1}}}

\def\latinkeywords#1{\par \vspace{5mm}
\noindent {\textbf{Keywords:}} {\textit{ #1}}}

\font\titlefont=cmssbx10 scaled 2074
\font\supervisorfont=cmbxti10
\def\makelatintitle{\begin{titlepage}
{\includegraphics{logo}}
\vskip 1.5cm
\addtolength{\baselineskip}{5mm}
{\titlefont \@latintitle} \par
\addtolength{\baselineskip}{-5mm}
\vskip 1cm
{\bfseries\latinby}\par
{\Large\bfseries \@latinauthor}\par
\vskip 5mm
{\latinwrittenfor\par
\large\@latindegree}
\par
\vskip 1cm
Under supervision of \\
{\supervisorfont\@latinsupervisor}
\par
\vskip 1cm
{\@latinthesisdate}
\par
\vskip 1cm
\large\bfseries
\@latindepartment\space Department
\par
\@latinuniversity \par\@latincity
\vfill
\end{titlepage}%
}

\def\acknowledgementname{قدردانی}
\def\by{توسط}
\def\writtenfor{  رسالهٔ ارائه شده به عنوان بخشی از ملزومات برای دریافت درجهٔ}
\def\undersupervision{زیر نظر}
\def\departmentof{دانشکدهٔ}
\def\universityof{دانشگاه}
\def\latinby{by}
\def\latinwrittenfor{Submitted in Partial Fulfillment\\ of the Requirements\\ for the Degree of}
\def\latinundersupervision{Under supervision of}
%% 
%% Copyright © 2008-2009      by Vafa Khalighi     <vafa@users.berlios.de>
%% 
%% Distributable under the LaTeX Project Public License,
%% version 1.3c or higher (your choice). The latest version of
%% this license is at: http://www.latex-project.org/lppl.txt
%% 
%% This work is "maintained" (as per LPPL maintenance status)
%% by Vafa Khalighi.
%% 
%% 
%% 
%% 
%%
%% End of file `xepersian-thesis.cls'.
