
#include "config.h"
#include "i18n.h"

#include "rwcacheprogress.h"

extern void RWFlushInterface();


RWCacheProgress::RWCacheProgress(WMBox *parent, WMLabel *label) 
    : _parent(parent), _label(label)
{
    _prog = WMCreateProgressIndicator(parent);

    WMSetLabelText(label, (char*)Op.c_str());

    _mapped = false;
}


RWCacheProgress::~RWCacheProgress()
{
    WMDestroyWidget(_prog);
}


void RWCacheProgress::Update()
{
    if (!CheckChange()) {
	RWFlushInterface();
	return;
    }
    
    if (!_mapped) {
	WMMapWidget(_prog);
	WMAddBoxSubview(_parent, WMWidgetView(_prog), True, True, 100, 0, 0);
	_mapped = true;
    }

    if (MajorChange)
	WMSetLabelText(_label, (char*)Op.c_str());

    WMSetProgressIndicatorValue(_prog, (int)Percent);

    RWFlushInterface();
    
}


void RWCacheProgress::Done()
{
    WMSetProgressIndicatorValue(_prog, 100);
    RWFlushInterface();

    WMUnmapWidget(_prog);
    WMRemoveBoxSubview(_parent, WMWidgetView(_prog));

    _mapped = false;
}
