#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - RFC822 comment pruning within file names
  - Filename mangling (mangle policy)
  - Defanging of Unix shell scripts

tac
$ANOMY/bin/sanitizer.pl $SAN_CONF \
    'header_rev = 0' \
    'file_list_1 = (?i)evil$' 'file_list_1_policy = mangle' \
    'feat_testing = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="this.is.ev(with a comment)il"
Content-Transfer-Encoding: 8bit
X-MAC-Something: Used by Eudora

#!/bin/bash
#
blah blah
blah
blah blah blah
blah

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF
